/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ExpireEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.entity.EntityItemBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={EntityItem.class})
public abstract class EntityItemMixin
extends EntityMixin
implements EntityItemBridge {
    private static final int MAGIC_PREVIOUS = -1;
    @Shadow
    private int field_145804_b;
    @Shadow
    private int field_70292_b;
    private double cachedRadius = -1.0;
    private int previousPickupDelay = -1;
    private boolean infinitePickupDelay;
    private int previousDespawnDelay = -1;
    private boolean infiniteDespawnDelay;
    public float dropChance = 1.0f;

    @Shadow
    public abstract ItemStack func_92059_d();

    @Override
    public boolean bridge$infinitePickupDelay() {
        return this.infinitePickupDelay;
    }

    @ModifyConstant(method={"searchForOtherItemsNearby"}, constant={@Constant(doubleValue=0.5)})
    private double impl$changeSearchRadiusFromConfig(double originalRadius) {
        if (this.field_70170_p.field_72995_K || ((WorldBridge)this.field_70170_p).bridge$isFake()) {
            return originalRadius;
        }
        if (this.cachedRadius == -1.0) {
            double configRadius = ((WorldInfoBridge)this.field_70170_p.func_72912_H()).bridge$getConfigAdapter().getConfig().getWorld().getItemMergeRadius();
            this.cachedRadius = configRadius < 0.0 ? 0.0 : configRadius;
        }
        return this.cachedRadius;
    }

    @Override
    public int bridge$getPickupDelay() {
        return this.infinitePickupDelay ? this.previousPickupDelay : this.field_145804_b;
    }

    @Override
    public void bridge$setPickupDelay(int delay, boolean infinite) {
        this.field_145804_b = delay;
        boolean previous = this.infinitePickupDelay;
        this.infinitePickupDelay = infinite;
        if (infinite && !previous) {
            this.previousPickupDelay = this.field_145804_b;
            this.field_145804_b = Short.MAX_VALUE;
        } else if (!infinite) {
            this.previousPickupDelay = -1;
        }
    }

    @Override
    public boolean bridge$infiniteDespawnDelay() {
        return this.infiniteDespawnDelay;
    }

    @Override
    public int bridge$getDespawnDelay() {
        return 6000 - (this.infiniteDespawnDelay ? this.previousDespawnDelay : this.field_70292_b);
    }

    @Override
    public void bridge$setDespawnDelay(int delay) {
        this.field_70292_b = 6000 - delay;
    }

    @Override
    public void bridge$setDespawnDelay(int delay, boolean infinite) {
        this.field_70292_b = 6000 - delay;
        boolean previous = this.infiniteDespawnDelay;
        this.infiniteDespawnDelay = infinite;
        if (infinite && !previous) {
            this.previousDespawnDelay = this.field_70292_b;
            this.field_70292_b = Short.MIN_VALUE;
        } else if (!infinite) {
            this.previousDespawnDelay = -1;
        }
    }

    @Override
    public void spongeImpl$readFromSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$readFromSpongeCompound(compound);
        this.infinitePickupDelay = compound.func_74767_n("InfinitePickupDelay");
        this.previousPickupDelay = compound.func_150297_b("PreviousPickupDelay", 99) ? compound.func_74762_e("PreviousPickupDelay") : -1;
        this.infiniteDespawnDelay = compound.func_74767_n("InfiniteDespawnDelay");
        this.previousDespawnDelay = compound.func_150297_b("PreviousDespawnDelay", 99) ? compound.func_74762_e("PreviousDespawnDelay") : -1;
        if (this.infinitePickupDelay) {
            if (this.previousPickupDelay != this.field_145804_b) {
                this.previousPickupDelay = this.field_145804_b;
            }
            this.field_145804_b = Short.MAX_VALUE;
        } else if (this.field_145804_b == Short.MAX_VALUE && this.previousPickupDelay != -1) {
            this.field_145804_b = this.previousPickupDelay;
            this.previousPickupDelay = -1;
        }
        if (this.infiniteDespawnDelay) {
            if (this.previousDespawnDelay != this.field_70292_b) {
                this.previousDespawnDelay = this.field_70292_b;
            }
            this.field_70292_b = Short.MIN_VALUE;
        } else if (this.field_70292_b == Short.MIN_VALUE && this.previousDespawnDelay != -1) {
            this.field_70292_b = this.previousDespawnDelay;
            this.previousDespawnDelay = -1;
        }
    }

    @Override
    public void spongeImpl$writeToSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$writeToSpongeCompound(compound);
        compound.func_74757_a("InfinitePickupDelay", this.infinitePickupDelay);
        compound.func_74777_a("PreviousPickupDelay", (short)this.previousPickupDelay);
        compound.func_74757_a("InfiniteDespawnDelay", this.infiniteDespawnDelay);
        compound.func_74777_a("PreviousDespawnDelay", (short)this.previousDespawnDelay);
    }

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityItem;setDead()V")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityItem;handleWaterMovement()Z"), to=@At(value="TAIL"))})
    private void impl$fireExpireEntityEventTargetItem(CallbackInfo ci) {
        if (!SpongeImplHooks.isMainThread() || this.func_92059_d().func_190926_b()) {
            return;
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            ExpireEntityEvent.TargetItem event = SpongeEventFactory.createExpireEntityEventTargetItem(frame.getCurrentCause(), (Item)((Object)this));
            SpongeImpl.postEvent(event);
        }
    }

    @Redirect(method={"onCollideWithPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/InventoryPlayer;addItemStackToInventory(Lnet/minecraft/item/ItemStack;)Z"))
    private boolean spongeImpl$throwPickupEventForAddItem(InventoryPlayer inventory, ItemStack itemStack, EntityPlayer player) {
        return SpongeCommonEventFactory.callPlayerChangeInventoryPickupEvent(player, (EntityItem)this);
    }
}

