/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.entity.player.EntityPlayerBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderBridge;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenericGenerationContext;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.common.util.SpawnerSpawnType;

@Mixin(value={WorldEntitySpawner.class})
public abstract class WorldEntitySpawnerMixin {
    @Nullable
    private static EntityType impl$spawnerEntityType;
    private final Set<Chunk> impl$eligibleSpawnChunks = Sets.newIdentityHashSet();

    @Overwrite
    public int func_77192_a(WorldServer world, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate) {
        if (!spawnHostileMobs && !spawnPeacefulMobs) {
            return 0;
        }
        try (Object context = GenerationPhase.State.WORLD_SPAWNER_SPAWNING.createPhaseContext().world((net.minecraft.world.World)world);){
            ((PhaseContext)context).buildAndSwitch();
            Iterator<Chunk> chunkIterator = this.impl$eligibleSpawnChunks.iterator();
            while (chunkIterator.hasNext()) {
                Chunk chunk = chunkIterator.next();
                ((ChunkBridge)chunk).bridge$setIsSpawning(false);
                chunkIterator.remove();
            }
            WorldServerBridge spongeWorld = (WorldServerBridge)world;
            spongeWorld.bridge$getTimingsHandler().mobSpawn.startTiming();
            int chunkSpawnCandidates = 0;
            int mobSpawnRange = Math.min(((WorldInfoBridge)world.func_72912_H()).bridge$getConfigAdapter().getConfig().getWorld().getMobSpawnRange(), ((World)world).getViewDistance());
            int MOB_SPAWN_COUNT_DIV = (2 * mobSpawnRange + 1) * (2 * mobSpawnRange + 1);
            for (EntityPlayer entityplayer : world.field_73010_i) {
                if (!((EntityPlayerBridge)entityplayer).bridge$affectsSpawning() || entityplayer.func_175149_v()) continue;
                int playerPosX = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
                int playerPosZ = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
                for (int i = -mobSpawnRange; i <= mobSpawnRange; ++i) {
                    for (int j = -mobSpawnRange; j <= mobSpawnRange; ++j) {
                        PlayerChunkMapEntry playerchunkmapentry;
                        boolean flag = i == -mobSpawnRange || i == mobSpawnRange || j == -mobSpawnRange || j == mobSpawnRange;
                        Chunk chunk = ((ChunkProviderBridge)world.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(i + playerPosX, j + playerPosZ);
                        if (chunk == null || chunk.field_189550_d && !((ChunkBridge)chunk).bridge$isPersistedChunk() || this.impl$eligibleSpawnChunks.contains(chunk)) continue;
                        ChunkBridge spongeChunk = (ChunkBridge)chunk;
                        ++chunkSpawnCandidates;
                        ChunkPos chunkPos = chunk.func_76632_l();
                        if (flag || !world.func_175723_af().func_177730_a(chunkPos) || (playerchunkmapentry = world.func_184164_w().func_187301_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) == null || !playerchunkmapentry.func_187274_e() || spongeChunk.bridge$isSpawning()) continue;
                        this.impl$eligibleSpawnChunks.add(chunk);
                        spongeChunk.bridge$setIsSpawning(true);
                    }
                }
            }
            if (this.impl$eligibleSpawnChunks.isEmpty()) {
                spongeWorld.bridge$getTimingsHandler().mobSpawn.stopTiming();
                int n = 0;
                return n;
            }
            int totalSpawned = 0;
            long worldTotalTime = world.func_82737_E();
            SpongeConfig<WorldConfig> configAdapter = ((WorldInfoBridge)world.func_72912_H()).bridge$getConfigAdapter();
            block18: for (EnumCreatureType enumCreatureType : EnumCreatureType.values()) {
                int maxCount;
                int entityCount;
                int limit = 0;
                int tickRate = 0;
                if (enumCreatureType == EnumCreatureType.MONSTER) {
                    limit = configAdapter.getConfig().getSpawner().getMonsterSpawnLimit();
                    tickRate = configAdapter.getConfig().getSpawner().getMonsterTickRate();
                } else if (enumCreatureType == EnumCreatureType.CREATURE) {
                    limit = configAdapter.getConfig().getSpawner().getAnimalSpawnLimit();
                    tickRate = configAdapter.getConfig().getSpawner().getAnimalTickRate();
                } else if (enumCreatureType == EnumCreatureType.WATER_CREATURE) {
                    limit = configAdapter.getConfig().getSpawner().getAquaticSpawnLimit();
                    tickRate = configAdapter.getConfig().getSpawner().getAquaticTickRate();
                } else if (enumCreatureType == EnumCreatureType.AMBIENT) {
                    limit = configAdapter.getConfig().getSpawner().getAmbientSpawnLimit();
                    tickRate = configAdapter.getConfig().getSpawner().getAmbientTickRate();
                }
                if (limit == 0 || tickRate == 0 || worldTotalTime % (long)tickRate != 0L || enumCreatureType.func_75599_d() && !spawnPeacefulMobs || !enumCreatureType.func_75599_d() && !spawnHostileMobs || (entityCount = SpongeImplHooks.countEntities(world, enumCreatureType, true)) > (maxCount = limit * chunkSpawnCandidates / MOB_SPAWN_COUNT_DIV)) continue;
                chunkIterator = this.impl$eligibleSpawnChunks.iterator();
                int mobLimit = maxCount - entityCount + 1;
                block19: while (chunkIterator.hasNext() && mobLimit > 0) {
                    Chunk chunk = chunkIterator.next();
                    BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                    BlockPos blockpos = WorldEntitySpawnerMixin.getRandomChunkPosition((net.minecraft.world.World)world, chunk);
                    int k1 = blockpos.func_177958_n();
                    int l1 = blockpos.func_177956_o();
                    int i2 = blockpos.func_177952_p();
                    IBlockState iblockstate = chunk.func_177435_g(blockpos);
                    if (iblockstate.func_185915_l()) continue;
                    int spawnCount = 0;
                    block20: for (int spawnLimit = 0; spawnLimit < 3; ++spawnLimit) {
                        int l2 = k1;
                        int i3 = l1;
                        int j3 = i2;
                        Biome.SpawnListEntry spawnListEntry = null;
                        IEntityLivingData ientitylivingdata = null;
                        int l3 = MathHelper.func_76143_f((double)(Math.random() * 4.0));
                        for (int i4 = 0; i4 < l3; ++i4) {
                            EntityLiving entityliving;
                            mutableBlockPos.func_181079_c(l2 += world.field_73012_v.nextInt(6) - world.field_73012_v.nextInt(6), i3 += world.field_73012_v.nextInt(1) - world.field_73012_v.nextInt(1), j3 += world.field_73012_v.nextInt(6) - world.field_73012_v.nextInt(6));
                            double spawnX = (float)l2 + 0.5f;
                            double spawnY = i3;
                            double spawnZ = (float)j3 + 0.5f;
                            if (world.func_175636_b(spawnX, spawnY, spawnZ, 24.0) || !(world.func_175694_M().func_177954_c(spawnX, spawnY, spawnZ) >= 576.0)) continue;
                            if (spawnListEntry == null && (spawnListEntry = world.func_175734_a(enumCreatureType, (BlockPos)mutableBlockPos)) == null) continue block20;
                            CatalogType entityType = EntityTypeRegistryModule.getInstance().getForClass(spawnListEntry.field_76300_b);
                            if (entityType != null) {
                                Vector3d vector3d = new Vector3d(spawnX, spawnY, spawnZ);
                                Transform<World> transform = new Transform<World>((World)world, vector3d);
                                ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(Sponge.getCauseStackManager().getCurrentCause(), (EntityType)entityType, transform);
                                if (SpongeImpl.postEvent(event)) continue;
                            }
                            if (!world.func_175732_a(enumCreatureType, spawnListEntry, (BlockPos)mutableBlockPos) || !WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntitySpawnPlacementRegistry.func_180109_a((Class)spawnListEntry.field_76300_b), (net.minecraft.world.World)world, (BlockPos)mutableBlockPos)) continue;
                            try {
                                entityliving = (EntityLiving)spawnListEntry.field_76300_b.getConstructor(net.minecraft.world.World.class).newInstance(world);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                continue block18;
                            }
                            entityliving.func_70012_b(spawnX, spawnY, spawnZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                            boolean entityNotColliding = entityliving.func_70058_J();
                            SpawnerSpawnType type = SpongeImplHooks.canEntitySpawnHere(entityliving, entityNotColliding);
                            if (type != SpawnerSpawnType.NONE) {
                                if (type == SpawnerSpawnType.NORMAL) {
                                    ientitylivingdata = entityliving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityliving)), ientitylivingdata);
                                    entityNotColliding = entityliving.func_70058_J();
                                }
                                if (entityNotColliding) {
                                    ++spawnCount;
                                    world.func_72838_d((Entity)entityliving);
                                } else {
                                    entityliving.func_70106_y();
                                }
                                if (--mobLimit <= 0 || spawnCount >= SpongeImplHooks.getMaxSpawnPackSize(entityliving)) continue block19;
                            }
                            totalSpawned += spawnCount;
                        }
                    }
                }
            }
            spongeWorld.bridge$getTimingsHandler().mobSpawn.stopTiming();
            int n = totalSpawned;
            return n;
        }
    }

    private static BlockPos getRandomChunkPosition(net.minecraft.world.World worldIn, Chunk chunk) {
        int i = chunk.field_76635_g * 16 + worldIn.field_73012_v.nextInt(16);
        int j = chunk.field_76647_h * 16 + worldIn.field_73012_v.nextInt(16);
        int k = MathHelper.func_154354_b((int)(chunk.func_177433_f(new BlockPos(i, 0, j)) + 1), (int)16);
        int l = worldIn.field_73012_v.nextInt(k > 0 ? k : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(i, l, j);
    }

    @Overwrite
    private static BlockPos func_180621_a(net.minecraft.world.World worldIn, int x, int z) {
        Chunk chunk = ((ChunkProviderBridge)worldIn.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(x, z);
        if (chunk == null || chunk.field_189550_d && !((ChunkBridge)chunk).bridge$isPersistedChunk()) {
            return null;
        }
        int i = x * 16 + worldIn.field_73012_v.nextInt(16);
        int j = z * 16 + worldIn.field_73012_v.nextInt(16);
        int k = MathHelper.func_154354_b((int)(chunk.func_177433_f(new BlockPos(i, 0, j)) + 1), (int)16);
        int l = worldIn.field_73012_v.nextInt(k > 0 ? k : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(i, l, j);
    }

    @Inject(method={"performWorldGenSpawning"}, at={@At(value="HEAD")})
    private static void onPerformWorldGenSpawningHead(net.minecraft.world.World worldServer, Biome biome, int j, int k, int l, int m, Random rand, CallbackInfo ci) {
        ((GenericGenerationContext)((GenericGenerationContext)GenerationPhase.State.WORLD_SPAWNER_SPAWNING.createPhaseContext().source(worldServer)).world(worldServer)).buildAndSwitch();
    }

    @Inject(method={"performWorldGenSpawning"}, at={@At(value="RETURN")})
    private static void onPerformWorldGenSpawningReturn(net.minecraft.world.World worldServer, Biome biome, int j, int k, int l, int m, Random rand, CallbackInfo ci) {
        PhaseTracker.getInstance().getCurrentContext().close();
        impl$spawnerEntityType = null;
    }

    @Redirect(method={"performWorldGenSpawning"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldEntitySpawner;canCreatureTypeSpawnAtLocation(Lnet/minecraft/entity/EntityLiving$SpawnPlacementType;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z"))
    private static boolean onCanGenerate(EntityLiving.SpawnPlacementType type, net.minecraft.world.World worldIn, BlockPos pos) {
        return WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)type, (net.minecraft.world.World)worldIn, (BlockPos)pos) && WorldEntitySpawnerMixin.check(pos, worldIn);
    }

    @Redirect(method={"performWorldGenSpawning"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/WeightedRandom;getRandomItem(Ljava/util/Random;Ljava/util/List;)Lnet/minecraft/util/WeightedRandom$Item;"))
    private static WeightedRandom.Item onGetRandom(Random random, List<Biome.SpawnListEntry> collection) {
        Biome.SpawnListEntry entry = (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)random, collection);
        WorldEntitySpawnerMixin.setEntityType(entry.field_76300_b);
        return entry;
    }

    private static void setEntityType(Class<? extends Entity> entityclass) {
        impl$spawnerEntityType = EntityTypeRegistryModule.getInstance().getForClass((Class)entityclass);
    }

    private static boolean check(BlockPos pos, net.minecraft.world.World world) {
        EntityType entityType = impl$spawnerEntityType;
        if (entityType == null) {
            return true;
        }
        Vector3d vector3d = new Vector3d(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        Transform<World> transform = new Transform<World>((World)world, vector3d);
        Sponge.getCauseStackManager().pushCause(world);
        ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(Sponge.getCauseStackManager().getCurrentCause(), entityType, transform);
        SpongeImpl.postEvent(event);
        Sponge.getCauseStackManager().popCause();
        return !event.isCancelled();
    }
}

