/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.advancement;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.advancements.AdvancementList;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.mixin.core.advancements.AdvancementListAccessor;
import org.spongepowered.common.registry.CustomRegistrationPhase;
import org.spongepowered.common.registry.type.AbstractPrefixCheckCatalogRegistryModule;
import org.spongepowered.common.registry.type.advancement.AdvancementRegistryModule;

@CustomRegistrationPhase
public class AdvancementTreeRegistryModule
extends AbstractPrefixCheckCatalogRegistryModule<AdvancementTree>
implements AdditionalCatalogRegistryModule<AdvancementTree> {
    public static AdvancementTreeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    AdvancementTreeRegistryModule() {
        super("minecraft");
    }

    @Override
    public void registerAdditionalCatalog(AdvancementTree advancementTree) {
        Preconditions.checkState((boolean)SpongeImplHooks.isMainThread());
        net.minecraft.advancements.Advancement advancement = (net.minecraft.advancements.Advancement)advancementTree.getRootAdvancement();
        AdvancementList advList = AdvancementRegistryModule.getAdvancementList();
        ((AdvancementListAccessor)advList).accessor$getRootsSet().add(advancement);
        AdvancementList.Listener listener = ((AdvancementListAccessor)advList).accessor$getListener();
        if (listener != null) {
            listener.func_191931_a(advancement);
        }
    }

    void clear() {
        this.catalogTypeMap.clear();
    }

    void registerSilently(net.minecraft.advancements.Advancement rootAdvancement) {
        Optional<AdvancementTree> optTree = ((Advancement)rootAdvancement).getTree();
        if (optTree.isPresent()) {
            super.register((CatalogType)optTree.get());
        } else {
            SpongeImpl.getLogger().warn("Attempted to register a root advancement {} without a advancement tree?", (Object)rootAdvancement.func_192067_g());
        }
    }

    void remove(net.minecraft.advancements.Advancement rootAdvancement) {
        Optional<AdvancementTree> optTree = ((Advancement)rootAdvancement).getTree();
        optTree.ifPresent(advancementTree -> {
            AdvancementTree cfr_ignored_0 = (AdvancementTree)this.catalogTypeMap.remove(advancementTree.getId());
        });
    }

    private static final class Holder {
        static final AdvancementTreeRegistryModule INSTANCE = new AdvancementTreeRegistryModule();

        private Holder() {
        }
    }
}

