/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.populator.BigMushroom;

public class BigMushroomBuilder
implements BigMushroom.Builder {
    private WeightedTable<PopulatorObject> types;
    @Nullable
    private Function<Location<Extent>, PopulatorObject> override;
    private VariableAmount count;

    public BigMushroomBuilder() {
        this.reset();
    }

    @Override
    public BigMushroom.Builder types(WeightedTable<PopulatorObject> types) {
        Preconditions.checkNotNull(types, (Object)"types");
        this.types = types;
        return this;
    }

    @Override
    public BigMushroom.Builder type(PopulatorObject type, double weight) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0);
        this.types.add((TableEntry<PopulatorObject>)new WeightedObject<PopulatorObject>(type, weight));
        return this;
    }

    @Override
    public BigMushroom.Builder mushroomsPerChunk(VariableAmount count) {
        this.count = (VariableAmount)Preconditions.checkNotNull((Object)count, (Object)"count");
        return this;
    }

    @Override
    public BigMushroom.Builder supplier(@Nullable Function<Location<Extent>, PopulatorObject> override) {
        this.override = override;
        return this;
    }

    @Override
    public BigMushroom.Builder from(BigMushroom value) {
        this.types = value.getTypes();
        this.override = value.getSupplierOverride().orElse(null);
        this.count = value.getMushroomsPerChunk();
        return this;
    }

    @Override
    public BigMushroom.Builder reset() {
        this.types = new WeightedTable();
        this.count = VariableAmount.fixed(1.0);
        this.override = null;
        return this;
    }

    @Override
    public BigMushroom build() throws IllegalStateException {
        BigMushroom populator = (BigMushroom)new WorldGenBigMushroom((Block)Blocks.field_150338_P);
        populator.getTypes().clear();
        populator.getTypes().addAll((Collection<TableEntry<PopulatorObject>>)this.types);
        populator.setMushroomsPerChunk(this.count);
        populator.setSupplierOverride(this.override);
        return populator;
    }
}

