/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.teleport;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.category.TeleportHelperCategory;

public class ConfigTeleportHelperFilter
implements TeleportHelperFilter {
    @Nullable
    private static List<BlockType> floorBlockTypes = null;
    @Nullable
    private static List<BlockState> floorBlockStates = null;
    @Nullable
    private static List<BlockType> bodyBlockTypes = null;
    @Nullable
    private static List<BlockState> bodyBlockStates = null;

    public static void invalidateCache() {
        floorBlockTypes = null;
        floorBlockStates = null;
        bodyBlockStates = null;
        bodyBlockTypes = null;
    }

    private static void updateCacheIfNecessary() {
        if (floorBlockTypes == null) {
            TeleportHelperCategory teleportHelperCat = SpongeImpl.getGlobalConfigAdapter().getConfig().getTeleportHelper();
            floorBlockTypes = teleportHelperCat.getUnsafeFloorBlockIds().stream().map(x -> Sponge.getRegistry().getType(BlockType.class, x.toLowerCase(Locale.ENGLISH)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
            floorBlockStates = teleportHelperCat.getUnsafeFloorBlockIds().stream().map(x -> Sponge.getRegistry().getType(BlockState.class, x.toLowerCase(Locale.ENGLISH)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
            bodyBlockTypes = teleportHelperCat.getUnsafeBodyBlockIds().stream().map(x -> Sponge.getRegistry().getType(BlockType.class, x.toLowerCase(Locale.ENGLISH)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
            bodyBlockStates = teleportHelperCat.getUnsafeBodyBlockIds().stream().map(x -> Sponge.getRegistry().getType(BlockState.class, x.toLowerCase(Locale.ENGLISH)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    @Override
    public String getId() {
        return "sponge:config";
    }

    @Override
    public String getName() {
        return "Config Teleport Helper filter";
    }

    @Override
    public boolean isSafeFloorMaterial(BlockState blockState) {
        ConfigTeleportHelperFilter.updateCacheIfNecessary();
        return !floorBlockStates.contains(blockState) && !floorBlockTypes.contains(blockState.getType());
    }

    @Override
    public boolean isSafeBodyMaterial(BlockState blockState) {
        ConfigTeleportHelperFilter.updateCacheIfNecessary();
        return !bodyBlockStates.contains(blockState) && !bodyBlockTypes.contains(blockState.getType());
    }
}

