/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.world;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.BlockSnapshot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.mod.bridge.world.WorldBridge_Forge;
import org.spongepowered.mod.event.CapturedSnapshotWrapperList;

@Mixin(value={World.class}, priority=999)
public abstract class WorldMixin_Forge
implements WorldBridge_Forge {
    private WorldInfo forgeImpl$redirectWorldInfo;
    @Shadow(remap=false)
    public ArrayList<BlockSnapshot> capturedBlockSnapshots;
    @Shadow
    @Final
    public WorldProvider field_73011_w;
    @Shadow
    @Final
    public boolean field_72995_K;
    @Shadow
    protected MapStorage field_72988_C;
    @Shadow
    protected WorldInfo field_72986_A;

    @Shadow
    public abstract boolean func_175678_i(BlockPos var1);

    @Shadow
    public abstract IBlockState func_180495_p(BlockPos var1);

    @Shadow
    public abstract int func_175642_b(EnumSkyBlock var1, BlockPos var2);

    @Shadow
    public abstract void func_175666_e(BlockPos var1, Block var2);

    @Shadow
    public boolean func_175660_a(EntityPlayer player, BlockPos pos) {
        return false;
    }

    @Shadow
    public abstract long func_82737_E();

    @Overwrite
    private int func_175638_a(BlockPos pos, EnumSkyBlock lightType) {
        if (lightType == EnumSkyBlock.SKY && this.func_175678_i(pos)) {
            return 15;
        }
        IBlockState blockState = this.func_180495_p(pos);
        int blockLight = SpongeImplHooks.getChunkPosLight(blockState, (World)this, pos);
        int i = lightType == EnumSkyBlock.SKY ? 0 : blockLight;
        int j = SpongeImplHooks.getBlockLightOpacity(blockState, (IBlockAccess)((World)this), pos);
        if (j >= 15 && blockLight > 0) {
            j = 1;
        }
        if (j < 1) {
            j = 1;
        }
        if (j >= 15) {
            return 0;
        }
        if (i >= 14) {
            return i;
        }
        for (EnumFacing enumfacing : EnumFacing.values()) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            int k = this.func_175642_b(lightType, blockpos) - j;
            if (k > i) {
                i = k;
            }
            if (i < 14) continue;
            return i;
        }
        return i;
    }

    @Redirect(method={"updateEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isBlockLoaded(Lnet/minecraft/util/math/BlockPos;Z)Z"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;isInvalid()Z", ordinal=0), to=@At(value="INVOKE", target="Lnet/minecraft/world/border/WorldBorder;contains(Lnet/minecraft/util/math/BlockPos;)Z")))
    private boolean forgeImpl$useTileActiveChunk(World world, BlockPos pos, boolean allowEmpty) {
        return true;
    }

    @Redirect(method={"removeTileEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;updateComparatorOutputLevel(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;)V"))
    protected void forgeImpl$UseComparatorOutputLevel(World world, BlockPos pos, Block blockIn, BlockPos samePos) {
        this.func_175666_e(pos, blockIn);
    }

    @Inject(method={"getWorldInfo"}, at={@At(value="HEAD")}, cancellable=true)
    private void forgeImpl$getRedirectedWorldInfoIfAvailable(CallbackInfoReturnable<WorldInfo> cir) {
        if (this.field_73011_w.getDimension() != 0 && this.forgeImpl$redirectWorldInfo != null) {
            cir.setReturnValue(this.forgeImpl$redirectWorldInfo);
        }
    }

    @Inject(method={"getMapStorage"}, at={@At(value="HEAD")}, cancellable=true)
    private void forgeImpl$getOverworldMapStorageInsteadOfMultiDimension(CallbackInfoReturnable<MapStorage> cir) {
        WorldServer overworld;
        if (!(this.field_72995_K || this.field_72988_C != null && this.field_73011_w.getDimension() == 0 || (overworld = DimensionManager.getWorld((int)0)) == null)) {
            cir.setReturnValue(overworld.func_175693_T());
        }
    }

    @Override
    public void forgeBridge$setRedirectedWorldInfo(@Nullable WorldInfo info) {
        this.forgeImpl$redirectWorldInfo = info;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onIniitToSetForgeList(ISaveHandler saveHandlerIn, WorldInfo info, WorldProvider providerIn, Profiler profilerIn, boolean client, CallbackInfo ci) {
        if (!((WorldBridge)((Object)this)).bridge$isFake()) {
            this.capturedBlockSnapshots = new CapturedSnapshotWrapperList((World)this);
        }
    }

    @ModifyArg(method={"updateWeatherBody"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/WorldInfo;setRainTime(I)V"))
    int vanillaImpl$updateRainTimeStart(int newRainTime) {
        return newRainTime;
    }

    @ModifyArg(method={"updateWeatherBody"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/WorldInfo;setThunderTime(I)V"))
    int vanillaImpl$updateThunderTimeStart(int newThunderTime) {
        return newThunderTime;
    }
}

