/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.network;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.network.ChannelRegistrar;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.network.SpongeNetworkManager;
import org.spongepowered.mod.bridge.network.INetPlayHandlerBridge_Forge;

abstract class SpongeModChannelBinding
extends SpongeNetworkManager.AbstractChannelBinding {
    final EnumMap<Side, FMLEmbeddedChannel> channels;
    private boolean valid;

    public SpongeModChannelBinding(ChannelRegistrar registrar, String channelName, PluginContainer owner) {
        super(registrar, channelName, owner);
        this.channels = NetworkRegistry.INSTANCE.newChannel(channelName, this.getHandlers());
        this.valid = true;
    }

    protected abstract ChannelHandler[] getHandlers();

    protected final void checkValidState() {
        Preconditions.checkState((boolean)this.valid, (Object)"Channel bindng in invalid state (was it unbound?)");
    }

    protected void sendTo(Player player, Object data) {
        this.checkValidState();
        if (!((INetPlayHandlerBridge_Forge)((EntityPlayerMP)player).field_71135_a).forgeBridge$getRegisteredChannels().contains(this.getName())) {
            return;
        }
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush(data).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    protected void sendToServer(Object data) {
        this.checkValidState();
        if (!((INetPlayHandlerBridge_Forge)Minecraft.func_71410_x().field_71439_g.field_71174_a).forgeBridge$getRegisteredChannels().contains(this.getName())) {
            return;
        }
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush(data).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    protected void sendToAll(Object data) {
        this.checkValidState();
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush(data).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    final void invalidate() {
        this.valid = false;
    }
}

