/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.text;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import me.lucko.luckperms.lib.adventure.key.Key;
import me.lucko.luckperms.lib.adventure.text.BuildableComponent;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.ComponentBuilderApplicable;
import me.lucko.luckperms.lib.adventure.text.ComponentLike;
import me.lucko.luckperms.lib.adventure.text.event.ClickEvent;
import me.lucko.luckperms.lib.adventure.text.event.HoverEventSource;
import me.lucko.luckperms.lib.adventure.text.format.Style;
import me.lucko.luckperms.lib.adventure.text.format.TextColor;
import me.lucko.luckperms.lib.adventure.text.format.TextDecoration;
import me.lucko.luckperms.lib.adventure.util.Buildable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ComponentBuilder<C extends BuildableComponent<C, B>, B extends ComponentBuilder<C, B>>
extends Buildable.Builder<C>,
ComponentBuilderApplicable,
ComponentLike {
    public @NonNull B append(@NonNull Component var1);

    default public @NonNull B append(@NonNull ComponentLike component) {
        return this.append(component.asComponent());
    }

    default public @NonNull B append(@NonNull ComponentBuilder<?, ?> builder) {
        return this.append((Component)builder.build());
    }

    public @NonNull B append(Component ... var1);

    public @NonNull B append(ComponentLike ... var1);

    public @NonNull B append(@NonNull Iterable<? extends ComponentLike> var1);

    default public @NonNull B apply(@NonNull Consumer<? super ComponentBuilder<?, ?>> consumer) {
        consumer.accept(this);
        return (B)this;
    }

    public @NonNull B applyDeep(@NonNull Consumer<? super ComponentBuilder<?, ?>> var1);

    public @NonNull B mapChildren(@NonNull Function<BuildableComponent<?, ?>, ? extends BuildableComponent<?, ?>> var1);

    public @NonNull B mapChildrenDeep(@NonNull Function<BuildableComponent<?, ?>, ? extends BuildableComponent<?, ?>> var1);

    public @NonNull B style(@NonNull Style var1);

    public @NonNull B style(@NonNull Consumer<Style.Builder> var1);

    public @NonNull B font(@Nullable Key var1);

    public @NonNull B color(@Nullable TextColor var1);

    public @NonNull B colorIfAbsent(@Nullable TextColor var1);

    default public @NonNull B decorations(@NonNull Set<TextDecoration> decorations, boolean flag) {
        TextDecoration.State state = TextDecoration.State.byBoolean(flag);
        decorations.forEach(decoration -> this.decoration((TextDecoration)decoration, state));
        return (B)this;
    }

    default public @NonNull B decorate(@NonNull TextDecoration decoration) {
        return this.decoration(decoration, TextDecoration.State.TRUE);
    }

    default public @NonNull B decorate(TextDecoration ... decorations) {
        int length = decorations.length;
        for (int i = 0; i < length; ++i) {
            this.decorate(decorations[i]);
        }
        return (B)this;
    }

    default public @NonNull B decoration(@NonNull TextDecoration decoration, boolean flag) {
        return this.decoration(decoration, TextDecoration.State.byBoolean(flag));
    }

    public @NonNull B decoration(@NonNull TextDecoration var1, @NonNull TextDecoration.State var2);

    public @NonNull B clickEvent(@Nullable ClickEvent var1);

    public @NonNull B hoverEvent(@Nullable HoverEventSource<?> var1);

    public @NonNull B insertion(@Nullable String var1);

    default public @NonNull B mergeStyle(@NonNull Component that) {
        return this.mergeStyle(that, Style.Merge.all());
    }

    default public @NonNull B mergeStyle(@NonNull Component that, Style.Merge ... merges) {
        return this.mergeStyle(that, Style.Merge.of(merges));
    }

    public @NonNull B mergeStyle(@NonNull Component var1, @NonNull Set<Style.Merge> var2);

    public @NonNull B resetStyle();

    @Override
    public @NonNull C build();

    default public @NonNull B applicableApply(@NonNull ComponentBuilderApplicable applicable) {
        applicable.componentBuilderApply(this);
        return (B)this;
    }

    @Override
    default public void componentBuilderApply(@NonNull ComponentBuilder<?, ?> component) {
        component.append(this);
    }

    @Override
    default public @NonNull Component asComponent() {
        return this.build();
    }
}

