/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.function.UnaryOperator;
import me.lucko.luckperms.lib.adventure.key.Key;
import me.lucko.luckperms.lib.adventure.text.BlockNBTComponent;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.event.ClickEvent;
import me.lucko.luckperms.lib.adventure.text.event.HoverEvent;
import me.lucko.luckperms.lib.adventure.text.format.Style;
import me.lucko.luckperms.lib.adventure.text.format.TextColor;
import me.lucko.luckperms.lib.adventure.text.format.TextDecoration;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.BlockNBTComponentPosSerializer;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.ComponentSerializerImpl;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.GsonComponentSerializer;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.IndexedSerializer;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.KeySerializer;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.ShowEntitySerializer;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.ShowItemSerializer;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.StyleSerializer;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.TextColorSerializer;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.TextColorWrapper;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class GsonComponentSerializerImpl
implements GsonComponentSerializer {
    static final GsonComponentSerializer INSTANCE = new GsonComponentSerializerImpl(false, null, false);
    static final GsonComponentSerializer LEGACY_INSTANCE = new GsonComponentSerializerImpl(true, null, true);
    private final Gson serializer;
    private final UnaryOperator<GsonBuilder> populator;
    private final boolean downsampleColor;
    private final @Nullable LegacyHoverEventSerializer legacyHoverSerializer;
    private final boolean emitLegacyHover;

    GsonComponentSerializerImpl(boolean downsampleColor, @Nullable LegacyHoverEventSerializer legacyHoverSerializer, boolean emitLegacyHover) {
        this.downsampleColor = downsampleColor;
        this.legacyHoverSerializer = legacyHoverSerializer;
        this.emitLegacyHover = emitLegacyHover;
        this.populator = builder -> {
            builder.registerTypeHierarchyAdapter(Key.class, KeySerializer.INSTANCE);
            builder.registerTypeHierarchyAdapter(Component.class, (Object)new ComponentSerializerImpl());
            builder.registerTypeHierarchyAdapter(Style.class, (Object)new StyleSerializer(legacyHoverSerializer, emitLegacyHover));
            builder.registerTypeAdapter(ClickEvent.Action.class, IndexedSerializer.of("click action", ClickEvent.Action.NAMES));
            builder.registerTypeAdapter(HoverEvent.Action.class, IndexedSerializer.of("hover action", HoverEvent.Action.NAMES));
            builder.registerTypeAdapter(HoverEvent.ShowItem.class, (Object)new ShowItemSerializer());
            builder.registerTypeAdapter(HoverEvent.ShowEntity.class, (Object)new ShowEntitySerializer());
            builder.registerTypeAdapter(TextColorWrapper.class, (Object)new TextColorWrapper.Serializer());
            builder.registerTypeHierarchyAdapter(TextColor.class, downsampleColor ? TextColorSerializer.DOWNSAMPLE_COLOR : TextColorSerializer.INSTANCE);
            builder.registerTypeAdapter(TextDecoration.class, IndexedSerializer.of("text decoration", TextDecoration.NAMES));
            builder.registerTypeHierarchyAdapter(BlockNBTComponent.Pos.class, BlockNBTComponentPosSerializer.INSTANCE);
            return builder;
        };
        this.serializer = ((GsonBuilder)this.populator.apply(new GsonBuilder())).create();
    }

    @Override
    public @NonNull Gson serializer() {
        return this.serializer;
    }

    @Override
    public @NonNull UnaryOperator<GsonBuilder> populator() {
        return this.populator;
    }

    @Override
    public @NonNull Component deserialize(@NonNull String string) {
        return (Component)this.serializer().fromJson(string, Component.class);
    }

    @Override
    public @NonNull String serialize(@NonNull Component component) {
        return this.serializer().toJson((Object)component);
    }

    @Override
    public @NonNull GsonComponentSerializer.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    implements GsonComponentSerializer.Builder {
        private boolean downsampleColor = false;
        private @Nullable LegacyHoverEventSerializer legacyHoverSerializer;
        private boolean emitLegacyHover = false;

        BuilderImpl() {
        }

        BuilderImpl(GsonComponentSerializerImpl serializer) {
            this.downsampleColor = serializer.downsampleColor;
            this.emitLegacyHover = serializer.emitLegacyHover;
            this.legacyHoverSerializer = serializer.legacyHoverSerializer;
        }

        @Override
        public @NonNull GsonComponentSerializer.Builder downsampleColors() {
            this.downsampleColor = true;
            return this;
        }

        @Override
        public @NonNull GsonComponentSerializer.Builder legacyHoverEventSerializer(@Nullable LegacyHoverEventSerializer serializer) {
            this.legacyHoverSerializer = serializer;
            return this;
        }

        @Override
        public @NonNull GsonComponentSerializer.Builder emitLegacyHoverEvent() {
            this.emitLegacyHover = true;
            return this;
        }

        @Override
        public @NonNull GsonComponentSerializer build() {
            if (this.legacyHoverSerializer == null) {
                return this.downsampleColor ? LEGACY_INSTANCE : INSTANCE;
            }
            return new GsonComponentSerializerImpl(this.downsampleColor, this.legacyHoverSerializer, this.emitLegacyHover);
        }
    }
}

