/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.event;

import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.core.data.WorldDataSurvivalPlanet;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.planets.diona.dimension.WorldProviderDiona;
import stevekung.mods.moreplanets.planets.diona.entity.EntityAlienBeam;
import stevekung.mods.moreplanets.planets.nibiru.dimension.WorldProviderNibiru;
import stevekung.mods.moreplanets.planets.nibiru.entity.weather.EntityNibiruLightningBolt;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.biome.BiomeInfectedBadlands;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.biome.BiomeInfectedDesert;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.biome.BiomeInfectedMountains;
import stevekung.mods.stevekunglib.utils.event.WeatherTickEvent;

public class WorldTickEventHandler {
    public static WorldDataSurvivalPlanet survivalPlanetData = null;

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.loadPlanetData();
    }

    @SubscribeEvent
    public void onClientConnectServer(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        this.loadPlanetData();
    }

    @SubscribeEvent
    public void onWeatherTick(WeatherTickEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getStrikePos();
        if (DimensionManager.getWorld((int)ConfigManagerMP.moreplanets_dimension.idDimensionDiona) != null && world.field_73011_w instanceof WorldProviderDiona && this.canBeamStrike(world, pos) && world.field_73012_v.nextInt(75000) == 0 && world.func_175667_e(pos)) {
            EntityAlienBeam beam = new EntityAlienBeam(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            beam.spawnWeather();
        }
        if (DimensionManager.getWorld((int)ConfigManagerMP.moreplanets_dimension.idDimensionNibiru) != null && world.field_73011_w instanceof WorldProviderNibiru) {
            boolean raining = world.func_72896_J();
            boolean thunder = world.func_72911_I();
            Biome biome = world.func_180494_b(pos);
            if (world.field_73011_w.canDoLightning(event.getChunk()) && raining && thunder && world.field_73012_v.nextInt(1000) == 0 && world.func_175727_C(pos)) {
                EntityNibiruLightningBolt boltFire = new EntityNibiruLightningBolt(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), true);
                boltFire.spawnWeather();
            }
            if (world.field_73012_v.nextInt(16) == 0) {
                BlockPos pos1 = pos.func_177977_b();
                if (world.func_175697_a(pos1, 1) && world.func_175662_w(pos1)) {
                    world.func_175656_a(pos1, MPBlocks.INFECTED_ICE.func_176223_P());
                }
                if (raining) {
                    if (world.func_175708_f(pos, true)) {
                        world.func_175656_a(pos, biome == MPBiomes.COLD_GREEN_VEIN_MOUTAINS ? MPBlocks.PURIFIED_SNOW_LAYER.func_176223_P() : MPBlocks.INFECTED_SNOW_LAYER.func_176223_P());
                    }
                    if (world.func_180494_b(pos1).func_76738_d()) {
                        world.func_180495_p(pos1).func_177230_c().func_176224_k(world, pos1);
                    }
                }
            }
            if ((biome instanceof BiomeInfectedDesert || biome instanceof BiomeInfectedMountains || biome instanceof BiomeInfectedBadlands) && world.field_73012_v.nextInt(250000) == 0) {
                EntityNibiruLightningBolt bolt = new EntityNibiruLightningBolt(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), false);
                bolt.spawnWeather();
            }
        }
    }

    private boolean canBeamStrike(World world, BlockPos strikePosition) {
        if (!world.func_175678_i(strikePosition)) {
            return false;
        }
        if (world.func_175725_q(strikePosition).func_177956_o() > strikePosition.func_177956_o()) {
            return false;
        }
        return this.getSunBrightness(world) < 0.1f;
    }

    private float getSunBrightness(World world) {
        float angle = world.func_72826_c(1.0f);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.1f);
        value = MathHelper.func_76131_a((float)value, (float)0.55f, (float)1.0f);
        value = 1.0f - value;
        return value * 0.9f;
    }

    private void loadPlanetData() {
        World world = WorldUtil.getWorldForDimensionServer((int)0);
        if (world == null) {
            return;
        }
        survivalPlanetData = (WorldDataSurvivalPlanet)world.func_72943_a(WorldDataSurvivalPlanet.class, "SurvivalPlanetData");
        if (survivalPlanetData == null) {
            survivalPlanetData = new WorldDataSurvivalPlanet("SurvivalPlanetData");
            world.func_72823_a("SurvivalPlanetData", (WorldSavedData)survivalPlanetData);
        }
    }
}

