/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.tileentity;

import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.tileentity.TileEntityDummy;
import stevekung.mods.stevekunglib.utils.LangUtils;

public class TileEntitySpaceWarpPadFull
extends TileEntityDummy
implements IMultiBlock {
    private boolean initialised;

    public TileEntitySpaceWarpPadFull() {
        super("container.space_warp_pad.name");
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        this.storage.setMaxExtract(75.0f);
        this.storage.setCapacity(20000.0f);
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 0;
        }
    }

    public int getPacketCooldown() {
        return 1;
    }

    public void func_73660_a() {
        if (!this.initialised) {
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_175624_G() != WorldType.field_180272_g) {
                this.onCreate(this.field_145850_b, this.func_174877_v());
            }
            this.initialised = TileEntityDummy.initialiseMultiTiles(this.func_174877_v(), this.field_145850_b, this);
        }
        super.func_73660_a();
    }

    public boolean onActivated(EntityPlayer player) {
        return MPBlocks.SPACE_WARP_PAD_FULL.func_180639_a(this.field_145850_b, this.mainBlockPosition, MPBlocks.SPACE_WARP_PAD_FULL.func_176223_P(), player, player.func_184600_cs(), player.func_174811_aO(), 0.0f, 0.0f, 0.0f);
    }

    public void onCreate(World world, BlockPos placedPosition) {
        this.mainBlockPosition = placedPosition;
        this.func_70296_d();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(placedPosition, positions);
        MPBlocks.WARP_PAD_DUMMY.makeFakeBlock(world, positions, placedPosition);
    }

    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
        int y = placedPosition.func_177956_o();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (x == 0 && z == 0) continue;
                positions.add(new BlockPos(placedPosition.func_177958_n() + x, y, placedPosition.func_177952_p() + z));
            }
        }
    }

    public void onDestroy(TileEntity callingBlock) {
        BlockPos thisBlock = this.func_174877_v();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(thisBlock, positions);
        for (BlockPos pos : positions) {
            if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(pos, this.field_145850_b.func_180495_p(pos));
            }
            this.field_145850_b.func_175655_b(pos, false);
        }
        this.field_145850_b.func_175655_b(thisBlock, true);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)this.func_174877_v().func_177956_o() + 0.4, (double)(this.func_174877_v().func_177952_p() + 2));
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.hasWarpCore() && !this.disabled;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return EnumFacing.DOWN;
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    @Override
    public EnumFacing getFront() {
        return EnumFacing.DOWN;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180461_b(int slotID, ItemStack itemStack, EnumFacing side) {
        return slotID == 0;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 1) {
            return itemStack.func_77973_b() == MPItems.SPACE_WARPER_CORE;
        }
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    public BlockMulti.EnumBlockMultiType getMultiType() {
        return null;
    }

    public String getGUIStatus() {
        if (this.getEnergyStoredGC() == 0.0f) {
            return TextFormatting.DARK_RED + LangUtils.translate((String)"gui.status.missingpower.name");
        }
        if (this.getDisabled(0)) {
            return TextFormatting.GOLD + LangUtils.translate((String)"gui.status.ready.name");
        }
        if (this.getEnergyStoredGC() < this.storage.getMaxExtract()) {
            return TextFormatting.GOLD + LangUtils.translate((String)"gui.status.missingpower.name");
        }
        if (!this.hasWarpCore()) {
            return TextFormatting.DARK_RED + LangUtils.translate((String)"gui.status.warp_core_required.name");
        }
        if (this.hasWarpCore() && !((ItemStack)this.getInventory().get(1)).func_77942_o()) {
            return TextFormatting.DARK_RED + LangUtils.translate((String)"gui.status.empty_dimension_data.name");
        }
        return TextFormatting.DARK_GREEN + LangUtils.translate((String)"gui.status.active.name");
    }

    public boolean hasWarpCore() {
        return !((ItemStack)this.getInventory().get(1)).func_190926_b();
    }

    public BlockPos getDestinationPos() {
        if (this.hasWarpCore() && ((ItemStack)this.getInventory().get(1)).func_77942_o()) {
            NBTTagCompound compound = ((ItemStack)this.getInventory().get(1)).func_77978_p();
            return new BlockPos(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z"));
        }
        return null;
    }

    public int getDimensionId() {
        if (this.hasWarpCore() && ((ItemStack)this.getInventory().get(1)).func_77942_o()) {
            NBTTagCompound compound = ((ItemStack)this.getInventory().get(1)).func_77978_p();
            return compound.func_74762_e("DimensionID");
        }
        return 0;
    }

    public String getDimensionName() {
        if (this.hasWarpCore() && ((ItemStack)this.getInventory().get(1)).func_77942_o()) {
            NBTTagCompound compound = ((ItemStack)this.getInventory().get(1)).func_77978_p();
            return compound.func_74779_i("DimensionName");
        }
        return null;
    }

    public float getRotationPitch() {
        if (this.hasWarpCore() && ((ItemStack)this.getInventory().get(1)).func_77942_o()) {
            NBTTagCompound compound = ((ItemStack)this.getInventory().get(1)).func_77978_p();
            return compound.func_74760_g("Pitch");
        }
        return 0.0f;
    }

    public float getRotationYaw() {
        if (this.hasWarpCore() && ((ItemStack)this.getInventory().get(1)).func_77942_o()) {
            NBTTagCompound compound = ((ItemStack)this.getInventory().get(1)).func_77978_p();
            return compound.func_74760_g("Yaw");
        }
        return 0.0f;
    }
}

