/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.configurator.client.gui;

import com.google.common.eventbus.Subscribe;
import gcewing.sg.SGCraft;
import gcewing.sg.features.configurator.client.gui.GateAddressAccessEntryScreen;
import gcewing.sg.features.configurator.network.ConfiguratorNetworkHandler;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.tileentity.data.GateAccessData;
import gcewing.sg.util.GateUtil;
import gcewing.sg.util.SGAddressing;
import java.util.ArrayList;
import java.util.List;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.BasicScreen;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.BasicContainer;
import net.malisis.core.client.gui.component.container.BasicForm;
import net.malisis.core.client.gui.component.container.BasicList;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.decoration.UISeparator;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.UICheckBox;
import net.malisis.core.client.gui.component.interaction.button.builder.UIButtonBuilder;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.util.FontColors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GateAddressAccessScreen
extends BasicScreen {
    private int lastUpdate = 0;
    private boolean unlockMouse = true;
    private boolean isAdmin;
    private boolean delayedUpdate = false;
    private BasicForm form;
    private BasicContainer<?> addressContainer;
    private BasicContainer<?> addressOptionsContainer;
    private UIButton buttonClose;
    private UIButton addAddressButton;
    private UIButton editAddressButton;
    private UIButton deleteAddressButton;
    private UIButton saveOptionsButton;
    private UIButton saveDefaultOptionsButton;
    private UILabel addressListLabel;
    private UILabel gateDefaultIncomingLabel;
    private UILabel gateDefaultOutgoingLabel;
    private UILabel perAddressOptionsLabel;
    private UILabel gateIncomingLabel;
    private UILabel gateOutgoingLabel;
    private UICheckBox defaultAllowIncomingCheckbox;
    private UICheckBox defaultDenyIncomingCheckbox;
    private UICheckBox defaultAllowOutgoingCheckbox;
    private UICheckBox defaultDenyOutgoingCheckbox;
    private UICheckBox allowIncomingCheckbox;
    private UICheckBox denyIncomingCheckbox;
    private UICheckBox allowOutgoingCheckbox;
    private UICheckBox denyOutgoingCheckbox;
    private BlockPos location;
    private World world;
    private EntityPlayer player;
    private SGBaseTE localGate;
    private List<GateAccessData> clonedList;
    private BasicList<GateAccessData> gateAccessList;

    public GateAddressAccessScreen(BasicScreen parent, EntityPlayer player, World worldIn, boolean isAdmin) {
        super((GuiScreen)parent, true);
        this.player = player;
        this.isAdmin = false;
        this.world = worldIn;
        this.location = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
    }

    public void construct() {
        this.guiscreenBackground = false;
        Keyboard.enableRepeatEvents((boolean)true);
        TileEntity localGateTE = GateUtil.locateLocalGate(this.world, this.location, SGCraft.toolSearchRange, false);
        if (localGateTE instanceof SGBaseTE) {
            this.localGate = (SGBaseTE)localGateTE;
        }
        this.form = new BasicForm((MalisisGui)this, 300, 225, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.gateAddressAccessList", (Object[])new Object[0]));
        this.form.setMovable(true);
        this.form.setBackgroundAlpha(255);
        this.addressContainer = new BasicContainer((MalisisGui)this, 100, 145);
        this.addressContainer.setPosition(0, 0, Anchor.LEFT | Anchor.TOP);
        this.addressContainer.setBorder(0xFFFFFF, 1, 185);
        this.addressContainer.setPadding(0, 3);
        this.addressContainer.setBackgroundAlpha(0);
        this.addressListLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.addressList", (Object[])new Object[0]));
        this.addressListLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.addressListLabel.setPosition(0, 0, Anchor.CENTER | Anchor.TOP);
        this.gateAccessList = new BasicList((MalisisGui)this, 0, this.addressContainer.getHeight() - 14);
        this.gateAccessList.setPosition(0, 10);
        this.gateAccessList.setItemComponentFactory((x$0, x$1, x$2) -> new GateItemComponent((MalisisGui)x$0, (BasicList<GateAccessData>)x$1, (GateAccessData)x$2));
        this.gateAccessList.setItemComponentSpacing(1);
        this.gateAccessList.setPadding(2);
        this.gateAccessList.setName("List");
        this.gateAccessList.register((Object)this);
        this.gateAccessList.setBorder(0xFFFFFF, 1, 185);
        this.gateAccessList.setBorders(0xFFFFFF, 185, 0, 1, 0, 0);
        this.addressContainer.add(new UIComponent[]{this.addressListLabel, this.gateAccessList});
        this.perAddressOptionsLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.perAddressOptions", (Object[])new Object[0]));
        this.perAddressOptionsLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.perAddressOptionsLabel.setPosition(0, 0, Anchor.CENTER | Anchor.TOP);
        UISeparator optionsSeparator = new UISeparator((MalisisGui)this);
        optionsSeparator.setSize(this.perAddressOptionsLabel.getWidth() - 10, 1);
        optionsSeparator.setPosition(0, 10, Anchor.TOP | Anchor.CENTER);
        this.addressOptionsContainer = new BasicContainer((MalisisGui)this, 150, 145);
        this.addressOptionsContainer.setPosition(0, 0, Anchor.RIGHT | Anchor.TOP);
        this.addressOptionsContainer.setBorder(0xFFFFFF, 1, 185);
        this.addressOptionsContainer.setPadding(0, 3);
        this.addressOptionsContainer.setBackgroundAlpha(0);
        this.gateIncomingLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.incoming", (Object[])new Object[0]) + ":");
        this.gateIncomingLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.gateIncomingLabel.setPosition(5, 20, Anchor.TOP | Anchor.LEFT);
        this.allowIncomingCheckbox = new UICheckBox((MalisisGui)this);
        this.allowIncomingCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.allow", (Object[])new Object[0]));
        this.allowIncomingCheckbox.setPosition(this.gateIncomingLabel.getX() + this.gateIncomingLabel.getWidth() + 10, this.gateIncomingLabel.getY(), Anchor.LEFT | Anchor.TOP);
        this.allowIncomingCheckbox.setName("checkbox.allowincoming");
        this.allowIncomingCheckbox.setChecked(this.localGate.defaultAllowIncoming);
        this.allowIncomingCheckbox.register((Object)this);
        this.denyIncomingCheckbox = new UICheckBox((MalisisGui)this);
        this.denyIncomingCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.deny", (Object[])new Object[0]));
        this.denyIncomingCheckbox.setPosition(this.gateIncomingLabel.getX() + this.gateIncomingLabel.getWidth() + 10 + this.allowIncomingCheckbox.getWidth() + 10, this.gateIncomingLabel.getY(), Anchor.LEFT | Anchor.TOP);
        this.denyIncomingCheckbox.setName("checkbox.denyincoming");
        this.denyIncomingCheckbox.setChecked(!this.localGate.defaultAllowIncoming);
        this.denyIncomingCheckbox.register((Object)this);
        this.gateOutgoingLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.outgoing", (Object[])new Object[0]) + ":");
        this.gateOutgoingLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.gateOutgoingLabel.setPosition(5, this.gateIncomingLabel.getY() + 15, Anchor.TOP | Anchor.LEFT);
        this.allowOutgoingCheckbox = new UICheckBox((MalisisGui)this);
        this.allowOutgoingCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.allow", (Object[])new Object[0]));
        this.allowOutgoingCheckbox.setPosition(this.gateIncomingLabel.getX() + this.gateIncomingLabel.getWidth() + 10, this.gateOutgoingLabel.getY(), Anchor.LEFT | Anchor.TOP);
        this.allowOutgoingCheckbox.setName("checkbox.allowoutgoing");
        this.allowOutgoingCheckbox.setChecked(this.localGate.defaultAllowOutgoing);
        this.allowOutgoingCheckbox.register((Object)this);
        this.denyOutgoingCheckbox = new UICheckBox((MalisisGui)this);
        this.denyOutgoingCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.deny", (Object[])new Object[0]));
        this.denyOutgoingCheckbox.setPosition(this.gateOutgoingLabel.getX() + this.gateIncomingLabel.getWidth() + 10 + this.allowIncomingCheckbox.getWidth() + 10, this.gateOutgoingLabel.getY(), Anchor.LEFT | Anchor.TOP);
        this.denyOutgoingCheckbox.setName("checkbox.denyoutgoing");
        this.denyOutgoingCheckbox.setChecked(!this.localGate.defaultAllowOutgoing);
        this.denyOutgoingCheckbox.register((Object)this);
        this.saveOptionsButton = new UIButtonBuilder((MalisisGui)this).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.save", (Object[])new Object[0])).onClick(() -> {
            if (this.gateAccessList.getSize() > 0 && this.gateAccessList.getSelectedItem() != null && !((GateAccessData)this.gateAccessList.getSelectedItem()).getAddress().isEmpty()) {
                ConfiguratorNetworkHandler.sendGateAddressAccessInputToServer(this.localGate, ((GateAccessData)this.gateAccessList.getSelectedItem()).getAddress().toUpperCase(), false, false, this.allowIncomingCheckbox.isChecked(), this.allowOutgoingCheckbox.isChecked());
                SGBaseTE.sendBasicMsg(this.player, "changesSaved", new Object[0]);
            }
        }).anchor(Anchor.BOTTOM | Anchor.RIGHT).position(-5, 0).build("button.save");
        this.addressOptionsContainer.add(new UIComponent[]{this.perAddressOptionsLabel, optionsSeparator, this.gateIncomingLabel, this.allowIncomingCheckbox, this.denyIncomingCheckbox, this.gateOutgoingLabel, this.allowOutgoingCheckbox, this.denyOutgoingCheckbox, this.saveOptionsButton});
        this.addAddressButton = new UIButtonBuilder((MalisisGui)this).text(TextFormatting.GREEN + "+").onClick(() -> {
            if (this.localGate.getGateAccessData() == null || !this.localGate.getGateAccessData().stream().filter(g -> g.getAddress().equalsIgnoreCase(SGAddressing.formatAddress(this.localGate.homeAddress, "-", "-"))).findFirst().isPresent()) {
                new GateAddressAccessEntryScreen(this, this.player, this.localGate, "", SGAddressing.formatAddress(this.localGate.homeAddress, "-", "-"), 1).display();
            } else {
                new GateAddressAccessEntryScreen(this, this.player, this.localGate, "", "Address Here", 1).display();
            }
        }).anchor(Anchor.TOP | Anchor.LEFT).position(this.addressContainer.getWidth() + 17, 40).build("button.add");
        this.editAddressButton = new UIButtonBuilder((MalisisGui)this).text(TextFormatting.YELLOW + "?").onClick(() -> new GateAddressAccessEntryScreen(this, this.player, this.localGate, ((GateAccessData)this.gateAccessList.getSelectedItem()).getAddress(), "", 2).display()).anchor(Anchor.TOP | Anchor.LEFT).position(this.addAddressButton.getX(), this.addAddressButton.getY() + 20).build("button.details");
        this.deleteAddressButton = new UIButtonBuilder((MalisisGui)this).text(TextFormatting.RED + "-").onClick(() -> new GateAddressAccessEntryScreen(this, this.player, this.localGate, ((GateAccessData)this.gateAccessList.getSelectedItem()).getAddress(), "", 3).display()).anchor(Anchor.TOP | Anchor.LEFT).position(this.addAddressButton.getX(), this.editAddressButton.getY() + 20).build("button.remove");
        UISeparator defaultsSeparator = new UISeparator((MalisisGui)this);
        defaultsSeparator.setSize(this.form.getWidth() - 10, 1);
        defaultsSeparator.setPosition(0, -50, Anchor.BOTTOM | Anchor.CENTER);
        this.gateDefaultIncomingLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.defaultIncoming", (Object[])new Object[0]));
        this.gateDefaultIncomingLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.gateDefaultIncomingLabel.setPosition(5, -35, Anchor.BOTTOM | Anchor.LEFT);
        this.defaultAllowIncomingCheckbox = new UICheckBox((MalisisGui)this);
        this.defaultAllowIncomingCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.allow", (Object[])new Object[0]));
        this.defaultAllowIncomingCheckbox.setPosition(this.gateDefaultIncomingLabel.getX() + this.gateDefaultIncomingLabel.getWidth() + 10, this.gateDefaultIncomingLabel.getY(), Anchor.LEFT | Anchor.BOTTOM);
        this.defaultAllowIncomingCheckbox.setName("checkbox.defaultallowincoming");
        this.defaultAllowIncomingCheckbox.setChecked(this.localGate.defaultAllowIncoming);
        this.defaultAllowIncomingCheckbox.register((Object)this);
        this.defaultDenyIncomingCheckbox = new UICheckBox((MalisisGui)this);
        this.defaultDenyIncomingCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.deny", (Object[])new Object[0]));
        this.defaultDenyIncomingCheckbox.setPosition(this.gateDefaultIncomingLabel.getX() + this.gateDefaultIncomingLabel.getWidth() + 10 + this.defaultAllowIncomingCheckbox.getWidth() + 10, this.gateDefaultIncomingLabel.getY(), Anchor.LEFT | Anchor.BOTTOM);
        this.defaultDenyIncomingCheckbox.setName("checkbox.defaultdenyincoming");
        this.defaultDenyIncomingCheckbox.setChecked(!this.localGate.defaultAllowIncoming);
        this.defaultDenyIncomingCheckbox.register((Object)this);
        this.gateDefaultOutgoingLabel = new UILabel((MalisisGui)this, TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.defaultOutgoing", (Object[])new Object[0]));
        this.gateDefaultOutgoingLabel.setFontOptions(FontOptions.builder().from(FontColors.WHITE_FO).shadow(true).scale(1.0f).build());
        this.gateDefaultOutgoingLabel.setPosition(5, -20, Anchor.BOTTOM | Anchor.LEFT);
        this.defaultAllowOutgoingCheckbox = new UICheckBox((MalisisGui)this);
        this.defaultAllowOutgoingCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.allow", (Object[])new Object[0]));
        this.defaultAllowOutgoingCheckbox.setPosition(this.gateDefaultIncomingLabel.getX() + this.gateDefaultIncomingLabel.getWidth() + 10, this.gateDefaultOutgoingLabel.getY(), Anchor.LEFT | Anchor.BOTTOM);
        this.defaultAllowOutgoingCheckbox.setName("checkbox.defaultallowoutgoing");
        this.defaultAllowOutgoingCheckbox.setChecked(this.localGate.defaultAllowOutgoing);
        this.defaultAllowOutgoingCheckbox.register((Object)this);
        this.defaultDenyOutgoingCheckbox = new UICheckBox((MalisisGui)this);
        this.defaultDenyOutgoingCheckbox.setText(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.configurator.label.deny", (Object[])new Object[0]));
        this.defaultDenyOutgoingCheckbox.setPosition(this.gateDefaultIncomingLabel.getX() + this.gateDefaultIncomingLabel.getWidth() + 10 + this.defaultAllowIncomingCheckbox.getWidth() + 10, this.gateDefaultOutgoingLabel.getY(), Anchor.LEFT | Anchor.BOTTOM);
        this.defaultDenyOutgoingCheckbox.setName("checkbox.defaultdenyoutgoing");
        this.defaultDenyOutgoingCheckbox.setChecked(!this.localGate.defaultAllowOutgoing);
        this.defaultDenyOutgoingCheckbox.register((Object)this);
        this.buttonClose = new UIButtonBuilder((MalisisGui)this).width(40).anchor(Anchor.BOTTOM | Anchor.RIGHT).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.close", (Object[])new Object[0])).onClick(() -> ((GateAddressAccessScreen)this).close()).build("button.close");
        this.saveDefaultOptionsButton = new UIButtonBuilder((MalisisGui)this).text(TextFormatting.WHITE + I18n.func_135052_a((String)"sgcraft.gui.button.save", (Object[])new Object[0])).onClick(() -> {
            ConfiguratorNetworkHandler.sendGateAddressAccessInputToServer(this.localGate, "", this.defaultAllowIncomingCheckbox.isChecked(), this.defaultAllowOutgoingCheckbox.isChecked(), this.allowIncomingCheckbox.isChecked(), this.allowOutgoingCheckbox.isChecked());
            SGBaseTE.sendBasicMsg(this.player, "changesSaved", new Object[0]);
            this.close();
        }).anchor(Anchor.BOTTOM | Anchor.RIGHT).position(-(this.buttonClose.getX() + this.buttonClose.getWidth() + 5), 0).build("button.savedefaults");
        this.form.add(new UIComponent[]{this.addressContainer, defaultsSeparator, this.addAddressButton, this.editAddressButton, this.deleteAddressButton, this.gateDefaultIncomingLabel, this.gateDefaultOutgoingLabel, this.buttonClose});
        this.form.add(new UIComponent[]{this.addressOptionsContainer, this.saveDefaultOptionsButton});
        this.form.add(new UIComponent[]{this.defaultAllowIncomingCheckbox, this.defaultDenyIncomingCheckbox, this.defaultAllowOutgoingCheckbox, this.defaultDenyOutgoingCheckbox});
        this.addToScreen((UIComponent)this.form);
        this.loadData();
    }

    @Subscribe
    public void onListChange(BasicList.SelectEvent<GateAccessData> event) {
        boolean firstClick;
        boolean bl = firstClick = event.getOldValue() == null;
        if (this.localGate.getGateAccessData().size() > 0) {
            this.allowIncomingCheckbox.setChecked(this.localGate.allowIncomingAddress(((GateAccessData)event.getNewValue()).getAddress(), true));
            this.denyIncomingCheckbox.setChecked(!this.localGate.allowIncomingAddress(((GateAccessData)event.getNewValue()).getAddress(), true));
            this.allowOutgoingCheckbox.setChecked(this.localGate.allowOutgoingAddress(((GateAccessData)event.getNewValue()).getAddress(), true));
            this.denyOutgoingCheckbox.setChecked(!this.localGate.allowOutgoingAddress(((GateAccessData)event.getNewValue()).getAddress(), true));
            this.addressOptionsContainer.setEnabled(true);
        } else {
            this.addressOptionsContainer.setEnabled(false);
        }
    }

    @Subscribe
    public void onValueChange(ComponentEvent.ValueChange event) {
        switch (event.getComponent().getName()) {
            case "checkbox.defaultallowincoming": {
                this.defaultDenyIncomingCheckbox.setChecked(this.defaultAllowIncomingCheckbox.isChecked());
                break;
            }
            case "checkbox.defaultdenyincoming": {
                this.defaultAllowIncomingCheckbox.setChecked(this.defaultDenyIncomingCheckbox.isChecked());
                break;
            }
            case "checkbox.defaultallowoutgoing": {
                this.defaultDenyOutgoingCheckbox.setChecked(this.defaultAllowOutgoingCheckbox.isChecked());
                break;
            }
            case "checkbox.defaultdenyoutgoing": {
                this.defaultAllowOutgoingCheckbox.setChecked(this.defaultDenyOutgoingCheckbox.isChecked());
                break;
            }
            case "checkbox.allowincoming": {
                this.denyIncomingCheckbox.setChecked(this.allowIncomingCheckbox.isChecked());
                break;
            }
            case "checkbox.denyincoming": {
                this.allowIncomingCheckbox.setChecked(this.denyIncomingCheckbox.isChecked());
                break;
            }
            case "checkbox.allowoutgoing": {
                this.denyOutgoingCheckbox.setChecked(this.allowOutgoingCheckbox.isChecked());
                break;
            }
            case "checkbox.denyoutgoing": {
                this.allowOutgoingCheckbox.setChecked(this.denyOutgoingCheckbox.isChecked());
            }
        }
    }

    public void update(int mouseX, int mouseY, float partialTick) {
        super.update(mouseX, mouseY, partialTick);
        if (this.unlockMouse && this.lastUpdate == 25) {
            Mouse.setGrabbed((boolean)false);
            this.unlockMouse = false;
        }
        if (this.lastUpdate == 20) {
            this.editAddressButton.setEnabled(this.gateAccessList.getSize() > 0);
            this.deleteAddressButton.setEnabled(this.gateAccessList.getSize() > 0);
            if (!this.localGate.getGateAccessData().equals(this.clonedList)) {
                this.loadData();
            }
        }
        if (++this.lastUpdate > 60) {
            this.lastUpdate = 0;
        }
    }

    public void delayedUpdate() {
        this.lastUpdate = 0;
        this.delayedUpdate = true;
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        super.func_73869_a(keyChar, keyCode);
        this.lastUpdate = 0;
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.lastUpdate = 0;
    }

    public boolean func_73868_f() {
        return false;
    }

    private void loadData() {
        if (this.localGate != null && this.localGate.getGateAccessData() != null) {
            this.gateAccessList.setItems(this.localGate.getGateAccessData());
            this.gateAccessList.setSelectedItem(this.gateAccessList.getItems().stream().findFirst().orElse(null));
            this.clonedList = new ArrayList<GateAccessData>(this.localGate.getGateAccessData());
        }
    }

    private class GateItemComponent
    extends BasicList.ItemComponent<GateAccessData> {
        private UILabel addressLabel;

        public GateItemComponent(MalisisGui gui, BasicList<GateAccessData> parent, GateAccessData item) {
            super(gui, parent, (Object)item);
        }

        protected void construct(MalisisGui gui) {
            super.construct(gui);
            this.setHeight(15);
            this.setPadding(1);
            this.addressLabel = new UILabel(this.getGui(), TextFormatting.WHITE + ((GateAccessData)this.item).getAddress());
            this.addressLabel.setAnchor(Anchor.CENTER | Anchor.MIDDLE);
            this.add(new UIComponent[]{this.addressLabel});
        }

        public void update() {
        }
    }
}

