/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util;

import com.google.common.collect.ImmutableMap;
import ic2.core.Direction;
import ic2.core.platform.textures.Ic2Models;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.IFacingBlock;
import ic2.core.platform.textures.obj.ILayeredBlockModel;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class Ic2cExtrasLayeredModel
extends BaseModel {
    List<BakedQuad>[] quads;
    ILayeredBlockModel block;
    IBlockState meta;

    public Ic2cExtrasLayeredModel(ILayeredBlockModel model, IBlockState state) {
        super(Ic2Models.getBlockTransforms());
        this.block = model;
        this.meta = state;
    }

    public void init() {
        IFacingBlock facing;
        int layers = this.block.getLayers(this.meta);
        this.quads = this.createList(7);
        this.setParticalTexture(this.block.getParticleTexture(this.meta));
        EnumFacing blockFacing = EnumFacing.NORTH;
        ModelRotation rotation = ModelRotation.X0_Y0;
        if (this.block instanceof IFacingBlock && (facing = (IFacingBlock)this.block).hasRotation(this.meta)) {
            blockFacing = facing.getRotation(this.meta);
            Tuple result = Direction.getModelRotation((EnumFacing)blockFacing);
            rotation = ModelRotation.func_177524_a((int)((Integer)result.func_76341_a()), (int)((Integer)result.func_76340_b()));
        }
        for (int i = 0; i < layers; ++i) {
            AxisAlignedBB box = this.block.getRenderBox(this.meta, i);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                ModelRotation sideRotation = this.getRotation(blockFacing, side, rotation);
                BlockPartFace face = this.createBlockFace(side, i);
                TextureAtlasSprite sprite = this.block.getLayerTexture(this.meta, side, i);
                if (sprite == null) continue;
                this.quads[side.func_176745_a()].add(this.getBakery().func_178414_a(this.getMinBox(side, box), this.getMaxBox(side, box), face, sprite, side, sideRotation, null, false, true));
            }
        }
    }

    protected ModelRotation getRotation(EnumFacing facing, EnumFacing side, ModelRotation defaultRotation) {
        if (facing.func_176740_k().func_176722_c() && side.func_176740_k().func_176720_b()) {
            return defaultRotation;
        }
        return facing.func_176740_k().func_176720_b() && side.func_176740_k() == EnumFacing.Axis.X ? defaultRotation : ModelRotation.X0_Y0;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.quads[side == null ? 6 : side.func_176745_a()];
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)((Object)this), (Object)PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)this.getCamera(), (ItemCameraTransforms.TransformType)cameraTransformType).getRight());
    }

    protected BlockPartFace createBlockFace(EnumFacing side, int layer) {
        return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0));
    }
}

