/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util.guicomponent;

import ic2.core.block.base.tile.TileEntityNuclearReactorBase;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.item.reactor.base.ItemHeatVentBase;
import ic2.core.util.math.Box2D;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;

public class GuiComponentSteamReactorString
extends GuiComponent {
    TileEntityNuclearReactorBase reactor;

    public GuiComponentSteamReactorString(TileEntityNuclearReactorBase tile) {
        super(new Box2D(108, 136, 97, 13));
        this.reactor = tile;
    }

    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Collections.singletonList(GuiComponent.ActionRequest.FrontgroundDraw);
    }

    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        double steamPerTick = 0.0;
        for (ItemStack stack : this.reactor.inventory) {
            ItemHeatVentBase base;
            ItemHeatVentBase.VentProperty prop;
            if (!(stack.func_77973_b() instanceof ItemHeatVentBase) || (prop = (base = (ItemHeatVentBase)stack.func_77973_b()).getProperty(stack)) == null || prop.getType() != 1) continue;
            int customDamage = base.getCustomDamage(stack);
            double effizens = customDamage < 100 ? 0.0 : (double)customDamage / ((double)base.getMaxCustomDamage(stack) - 100.0) * 100.0;
            double steamProduction = (double)prop.getSelf() * effizens;
            steamProduction /= 100.0;
            steamProduction /= 40.0;
            steamPerTick += (steamProduction *= 160.0);
        }
        gui.drawString(Ic2cExtrasLang.REACTOR_STEAM.getLocalizedFormatted(new Object[]{(int)steamPerTick}), this.getPosition().getX() + 3, this.getPosition().getY() + 3, Color.cyan.hashCode());
    }
}

