/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.actuallycomputers.tile;

import de.canitzp.actuallycomputers.ACDriver;
import de.canitzp.actuallycomputers.ManagedTileEnvironment;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidRegistry;

public class CoffeeMaker
extends ACDriver<TileEntityCoffeeMachine> {
    public CoffeeMaker() {
        super(TileEntityCoffeeMachine.class);
    }

    @Override
    public ManagedTileEnvironment<TileEntityCoffeeMachine> create(TileEntityCoffeeMachine tile, EnumFacing side) {
        return new Env(tile, side, tile.name);
    }

    private static boolean canMakeCoffee(TileEntityCoffeeMachine tile) {
        return StackUtil.isValid((ItemStack)tile.inv.getStackInSlot(1)) && tile.inv.getStackInSlot(1).func_77973_b() == InitItems.itemMisc && tile.inv.getStackInSlot(1).func_77952_i() == TheMiscItems.CUP.ordinal() && !StackUtil.isValid((ItemStack)tile.inv.getStackInSlot(2)) && tile.coffeeCacheAmount >= 35 && tile.tank.getFluid() != null && tile.tank.getFluid().getFluid() == FluidRegistry.WATER && tile.tank.getFluidAmount() >= 500;
    }

    public static final class Env
    extends ManagedTileEnvironment<TileEntityCoffeeMachine> {
        public Env(TileEntityCoffeeMachine tile, EnumFacing side, String name) {
            super(tile, side, name);
        }

        @Callback(doc="function():boolean; Returns true if it was successfully started. Starts the coffee maker if it isn't already running.")
        public Object[] startCoffee(Context context, Arguments arguments) {
            if (((TileEntityCoffeeMachine)this.tile).brewTime <= 0 && CoffeeMaker.canMakeCoffee((TileEntityCoffeeMachine)this.tile)) {
                ((TileEntityCoffeeMachine)this.tile).brew();
                return new Object[]{true};
            }
            return new Object[]{false};
        }
    }
}

