/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjc;

import com.gmail.trentech.pjc.EventListener;
import com.gmail.trentech.pjc.commands.CMDPJC;
import com.gmail.trentech.pjc.core.BungeeManager;
import com.gmail.trentech.pjc.core.ConfigManager;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameConstructionEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;

@Plugin(id="pjc", name="ProjectCore", version="0.2.1", description="Core Libraries", authors={"TrenTech"}, url="http://github.com/TrenTech/ProjectCore")
public class Main {
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path path;
    @Inject
    private Logger log;
    private static PluginContainer plugin;
    private static Main instance;

    @Listener(order=Order.EARLY)
    public void onGameConstructionEvent(GameConstructionEvent event) {
        plugin = (PluginContainer)Sponge.getPluginManager().getPlugin("pjc").get();
        instance = this;
        try {
            Files.createDirectories(this.path, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Listener
    public void onInitialization(GameInitializationEvent event) {
        ConfigManager.init(Main.getPlugin());
        Sponge.getEventManager().registerListeners((Object)this, (Object)new EventListener());
        Sponge.getCommandManager().register((Object)this, (CommandCallable)new CMDPJC().getCommand(), new String[]{"pjc", "helpme", "hm"});
    }

    @Listener
    public void onStartedServerEvent(GameStartedServerEvent event) {
        BungeeManager.init();
    }

    @Listener
    public void onReloadEvent(GameReloadEvent event) {
        ConfigManager.init(Main.getPlugin());
    }

    public Logger getLog() {
        return this.log;
    }

    public Path getPath() {
        return this.path;
    }

    public static PluginContainer getPlugin() {
        return plugin;
    }

    public static Main instance() {
        return instance;
    }
}

