/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjc.core;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.TeleportHelper;
import org.spongepowered.api.world.World;

public class TeleportManager {
    private static final List<BlockType> unsafeBlocks = ImmutableList.of((Object)BlockTypes.AIR, (Object)BlockTypes.CACTUS, (Object)BlockTypes.FIRE, (Object)BlockTypes.LAVA, (Object)BlockTypes.FLOWING_LAVA, (Object)BlockTypes.FLOWING_WATER, (Object)BlockTypes.WATER);
    private static ThreadLocalRandom random = ThreadLocalRandom.current();

    public static Optional<Location<World>> getSafeLocation(Location<World> location) {
        TeleportHelper teleportHelper = Sponge.getGame().getTeleportHelper();
        Optional optionalLocation = Optional.of(location);
        block0: for (int i = 0; i < 10; ++i) {
            if (!optionalLocation.isPresent()) {
                optionalLocation = teleportHelper.getSafeLocation(location);
                continue;
            }
            Location<World> unsafeLocation = optionalLocation.get();
            if (!TeleportManager.isInWorldBorder(location)) {
                optionalLocation = teleportHelper.getSafeLocation(location);
                continue;
            }
            BlockType blockType = unsafeLocation.getBlockType();
            if (!blockType.equals(BlockTypes.AIR) || !unsafeLocation.getRelative(Direction.UP).getBlockType().equals(BlockTypes.AIR)) {
                optionalLocation = teleportHelper.getSafeLocation(location);
                continue;
            }
            Location floorLocation = unsafeLocation.getRelative(Direction.DOWN);
            for (int i2 = 0; i2 < 4; ++i2) {
                if (!floorLocation.getBlockType().equals(BlockTypes.AIR)) {
                    if (!unsafeBlocks.contains(floorLocation.getBlockType())) break;
                    optionalLocation = teleportHelper.getSafeLocation(location);
                    continue block0;
                }
                floorLocation = floorLocation.getRelative(Direction.DOWN);
            }
            if (floorLocation.getBlockType().equals(BlockTypes.AIR)) {
                optionalLocation = teleportHelper.getSafeLocation(location);
                continue;
            }
            ((World)unsafeLocation.getExtent()).loadChunk(unsafeLocation.getChunkPosition(), true);
            return optionalLocation;
        }
        return Optional.empty();
    }

    public static Optional<Location<World>> getRandomLocation(World world, int radius) {
        Location spawnLocation = world.getSpawnLocation();
        radius /= 2;
        for (int i = 0; i < 20; ++i) {
            double z;
            double y;
            double x = random.nextDouble() * (double)(radius * 2) - (double)radius + (double)spawnLocation.getBlockX();
            Optional<Location<World>> optionalLocation = TeleportManager.getSafeLocation((Location<World>)world.getLocation(x, y = random.nextDouble(59.0, 201.0), z = random.nextDouble() * (double)(radius * 2) - (double)radius + (double)spawnLocation.getBlockZ()));
            if (!optionalLocation.isPresent()) continue;
            return optionalLocation;
        }
        return Optional.empty();
    }

    public static boolean isInWorldBorder(Location<World> location) {
        World world = (World)location.getExtent();
        long radius = (long)(world.getWorldBorder().getDiameter() / 2.0);
        Vector3d displacement = location.getPosition().sub(world.getWorldBorder().getCenter()).abs();
        return !(displacement.getX() > (double)radius) && !(displacement.getZ() > (double)radius);
    }

    public static Consumer<CommandSource> setUnsafeLocation(Location<World> location) {
        return src -> {
            Player player = (Player)src;
            player.setLocation(location);
        };
    }
}

