/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.block;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import tinker_io.block.base.BlockFacingTileEntity;
import tinker_io.item.ItemBase;
import tinker_io.plugins.theoneprob.TOPInfoProvider;
import tinker_io.tileentity.TileEntityStirlingEngine;

public class BlockStirlingEngine
extends BlockFacingTileEntity<TileEntityStirlingEngine>
implements TOPInfoProvider {
    public BlockStirlingEngine(String name) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(3.0f);
    }

    @Override
    public Class<TileEntityStirlingEngine> getTileEntityClass() {
        return TileEntityStirlingEngine.class;
    }

    @Override
    @Nullable
    public TileEntityStirlingEngine createTileEntity(World world, IBlockState state) {
        return new TileEntityStirlingEngine();
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        String fuelAmountText = I18n.func_135052_a((String)"tio.toolTips.StirlingEngine.liquidAmount", (Object[])new Object[0]);
        String fuelTempText = I18n.func_135052_a((String)"tio.toolTips.StirlingEngine.liquidTemp", (Object[])new Object[0]);
        String energyStoredText = I18n.func_135052_a((String)"tio.toolTips.StirlingEngine.energyStored", (Object[])new Object[0]);
        String generatePerTickText = I18n.func_135052_a((String)"tio.toolTips.StirlingEngine.generatePerTick", (Object[])new Object[0]);
        TileEntityStirlingEngine te = (TileEntityStirlingEngine)worldIn.func_175625_s(pos);
        if (te != null) {
            playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + fuelAmountText + " : " + te.getFluidAmount()));
            playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + fuelTempText + " : " + te.getTemperature()));
            IEnergyStorage storage = this.getEnergyStorage(worldIn, pos);
            if (storage != null) {
                int energy = storage.getEnergyStored();
                if (worldIn.field_72995_K) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + energyStoredText + " : " + energy + " / " + storage.getMaxEnergyStored() + " RF"));
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + generatePerTickText + " : " + te.getRfPerTick() + " RF"));
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "-----"));
                }
            }
        }
        return true;
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null) {
            TileEntityStirlingEngine engine = (TileEntityStirlingEngine)te;
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null) {
                engine.setEnergyAmount(nbt.func_74762_e("energy"));
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return false;
        }
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), ItemStack.field_190927_a);
        }
        world.func_175698_g(pos);
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List items = super.getDrops(world, pos, state, fortune);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityStirlingEngine) {
            TileEntityStirlingEngine engine = (TileEntityStirlingEngine)te;
            for (ItemStack item : items) {
                if (item.func_77973_b() != Item.func_150898_a((Block)this)) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("energy", engine.getEnergyStored());
                item.func_77982_d(tag);
            }
        }
        return items;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    @Override
    public Item createItemBlock() {
        ItemBlock itemBlock = new ItemBlock(this){

            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                super.func_77624_a(stack, worldIn, tooltip, flagIn);
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt != null) {
                    int energy = nbt.func_74762_e("energy");
                    if (ItemBase.isShiftKeyDown()) {
                        String tips = TextFormatting.GREEN + I18n.func_135052_a((String)"tio.toolTips.itemBlock.StirlingEngine.energyStored", (Object[])new Object[]{energy});
                        tooltip.add(tips);
                    } else {
                        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"tio.toolTips.common.holdShift", (Object[])new Object[0]));
                    }
                }
            }
        };
        itemBlock.setRegistryName(this.getRegistryName());
        return itemBlock;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TileEntityStirlingEngine) {
            TileEntityStirlingEngine tile = (TileEntityStirlingEngine)te;
            String fuelAmountText = I18n.func_135052_a((String)"tio.toolTips.StirlingEngine.liquidAmount", (Object[])new Object[0]);
            String fuelTempText = I18n.func_135052_a((String)"tio.toolTips.StirlingEngine.liquidTemp", (Object[])new Object[0]);
            String energyStoredText = I18n.func_135052_a((String)"tio.toolTips.StirlingEngine.energyStored", (Object[])new Object[0]);
            String generatePerTickText = I18n.func_135052_a((String)"tio.toolTips.StirlingEngine.generatePerTick", (Object[])new Object[0]);
            probeInfo.vertical().text(TextFormatting.WHITE + fuelAmountText + " : " + tile.getFluidAmount()).text(TextFormatting.WHITE + fuelTempText + " : " + tile.getTemperature()).text("");
            IEnergyStorage storage = this.getEnergyStorage(world, data.getPos());
            if (storage != null) {
                int energy = tile.getEnergyStored();
                probeInfo.vertical().text(TextFormatting.WHITE + energyStoredText + " : " + energy + " / " + storage.getMaxEnergyStored() + " RF").text(TextFormatting.WHITE + generatePerTickText + " : " + tile.getRfPerTick() + " RF");
            }
        }
    }

    private IEnergyStorage getEnergyStorage(World word, BlockPos pos) {
        IEnergyStorage storage = null;
        TileEntity te = word.func_175625_s(pos);
        if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, null)) {
            storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
        }
        return storage;
    }
}

