/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcrestrict.Commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import net.moddedminecraft.mmcrestrict.Config.Messages;
import net.moddedminecraft.mmcrestrict.Data.ItemData;
import net.moddedminecraft.mmcrestrict.Data.ModData;
import net.moddedminecraft.mmcrestrict.Main;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;

public class BanList
implements CommandExecutor {
    private final Main plugin;

    public BanList(Main plugin) {
        this.plugin = plugin;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        ArrayList<ItemData> items = new ArrayList<ItemData>(this.plugin.getItemData());
        ArrayList<ModData> mods = new ArrayList<ModData>(this.plugin.getModData());
        Optional hidden = args.getOne("hidden");
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        ArrayList<Text> contents = new ArrayList<Text>();
        if (hidden.isPresent()) {
            String banInfo;
            String banreason;
            Text.Builder send;
            HashMap<String, String> arguments;
            for (ModData mod : mods) {
                if (!mod.getHidden().booleanValue()) continue;
                arguments = new HashMap<String, String>();
                arguments.put("banreason", mod.getBanreason());
                arguments.put("itemid", mod.getMod());
                arguments.put("usebanned", mod.getUsagebanned().toString());
                arguments.put("breakbanned", mod.getBreakingbanned().toString());
                arguments.put("placebanned", mod.getPlacingbanned().toString());
                arguments.put("ownbanned", mod.getOwnershipbanned().toString());
                arguments.put("craftbanned", mod.getCraftbanned().toString());
                arguments.put("worldbanned", "false");
                arguments.put("modname", mod.getModname());
                arguments.put("hidden", mod.getHidden() != false ? "show" : "hide");
                send = Text.builder();
                banreason = "";
                if (!mod.getBanreason().isEmpty()) {
                    banreason = Messages.bannedItemReason;
                }
                if (src.hasPermission("mmcrestrict.hidden.edit")) {
                    send.append(new Text[]{Text.builder().append(new Text[]{Messages.parseMessage(Messages.bannedListHidden, arguments)}).onClick((ClickAction)TextActions.executeCallback(this.changeHiddenMod(mod.getMod()))).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(Messages.bannedListHideHover, arguments))).build()});
                    send.append(new Text[]{this.plugin.fromLegacy(" ")});
                }
                banInfo = Messages.bannedItemHover;
                if (src.hasPermission("mmcrestrict.extra.list") && src.hasPermission("mmcrestrict.commands.edit")) {
                    banInfo = banInfo + "\n" + Messages.bannedItemExtraInfo + "\n" + Messages.bannedItemEdit;
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedMod + banreason, arguments)}).onClick((ClickAction)TextActions.runCommand((String)("/restrict edit " + mod.getMod()))).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                } else if (src.hasPermission("mmcrestrict.extra.list")) {
                    banInfo = banInfo + "\n" + Messages.bannedItemExtraInfo;
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedMod + banreason, arguments)}).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                } else if (src.hasPermission("mmcrestrict.commands.edit")) {
                    banInfo = banInfo + "\n" + Messages.bannedItemEdit;
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedMod + banreason, arguments)}).onClick((ClickAction)TextActions.runCommand((String)("/restrict edit " + mod.getMod()))).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                } else {
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedMod + banreason, arguments)}).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                }
                contents.add(send.build());
            }
            for (ItemData item : items) {
                if (!item.getHidden().booleanValue()) continue;
                arguments = new HashMap();
                arguments.put("banreason", item.getBanreason());
                arguments.put("itemid", item.getItemid());
                arguments.put("usebanned", item.getUsagebanned().toString());
                arguments.put("breakbanned", item.getBreakingbanned().toString());
                arguments.put("placebanned", item.getPlacingbanned().toString());
                arguments.put("ownbanned", item.getOwnershipbanned().toString());
                arguments.put("craftbanned", item.getCraftbanned().toString());
                arguments.put("worldbanned", item.getWorldbanned().toString());
                arguments.put("itemname", item.getItemname());
                arguments.put("hidden", item.getHidden() != false ? "show" : "hide");
                send = Text.builder();
                banreason = "";
                if (!item.getBanreason().isEmpty()) {
                    banreason = Messages.bannedItemReason;
                }
                if (src.hasPermission("mmcrestrict.hidden.edit")) {
                    send.append(new Text[]{Text.builder().append(new Text[]{Messages.parseMessage(Messages.bannedListHidden, arguments)}).onClick((ClickAction)TextActions.executeCallback(this.changeHidden(item.getItemid()))).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(Messages.bannedListHideHover, arguments))).build()});
                    send.append(new Text[]{this.plugin.fromLegacy(" ")});
                }
                banInfo = Messages.bannedItemHover;
                if (src.hasPermission("mmcrestrict.extra.list") && src.hasPermission("mmcrestrict.commands.edit")) {
                    banInfo = banInfo + "\n" + Messages.bannedItemExtraInfo + "\n" + Messages.bannedItemEdit;
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedItem + banreason, arguments)}).onClick((ClickAction)TextActions.runCommand((String)("/restrict edit " + item.getItemid()))).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                } else if (src.hasPermission("mmcrestrict.extra.list")) {
                    banInfo = banInfo + "\n" + Messages.bannedItemExtraInfo;
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedItem + banreason, arguments)}).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                } else if (src.hasPermission("mmcrestrict.commands.edit")) {
                    banInfo = banInfo + "\n" + Messages.bannedItemEdit;
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedItem + banreason, arguments)}).onClick((ClickAction)TextActions.runCommand((String)("/restrict edit " + item.getItemid()))).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                } else {
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedItem + banreason, arguments)}).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                }
                contents.add(send.build());
            }
        } else {
            String banInfo;
            String banreason;
            Text.Builder send;
            HashMap<String, String> arguments;
            for (ModData mod : mods) {
                if (mod.getHidden().booleanValue()) continue;
                arguments = new HashMap<String, String>();
                arguments.put("banreason", mod.getBanreason());
                arguments.put("itemid", mod.getMod());
                arguments.put("usebanned", mod.getUsagebanned().toString());
                arguments.put("breakbanned", mod.getBreakingbanned().toString());
                arguments.put("placebanned", mod.getPlacingbanned().toString());
                arguments.put("ownbanned", mod.getOwnershipbanned().toString());
                arguments.put("craftbanned", mod.getCraftbanned().toString());
                arguments.put("worldbanned", "false");
                arguments.put("modname", mod.getModname());
                arguments.put("hidden", mod.getHidden() != false ? "show" : "hide");
                send = Text.builder();
                banreason = "";
                if (!mod.getBanreason().isEmpty()) {
                    banreason = Messages.bannedItemReason;
                }
                if (src.hasPermission("mmcrestrict.hidden.edit")) {
                    send.append(new Text[]{Text.builder().append(new Text[]{Messages.parseMessage(Messages.bannedListHide, arguments)}).onClick((ClickAction)TextActions.executeCallback(this.changeHiddenMod(mod.getMod()))).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(Messages.bannedListHideHover, arguments))).build()});
                    send.append(new Text[]{this.plugin.fromLegacy(" ")});
                }
                banInfo = Messages.bannedItemHover;
                if (src.hasPermission("mmcrestrict.extra.list") && src.hasPermission("mmcrestrict.commands.edit")) {
                    banInfo = banInfo + "\n" + Messages.bannedItemExtraInfo + "\n" + Messages.bannedItemEdit;
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedMod + banreason, arguments)}).onClick((ClickAction)TextActions.runCommand((String)("/restrict edit " + mod.getMod()))).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                } else if (src.hasPermission("mmcrestrict.extra.list")) {
                    banInfo = banInfo + "\n" + Messages.bannedItemExtraInfo;
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedMod + banreason, arguments)}).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                } else if (src.hasPermission("mmcrestrict.commands.edit")) {
                    banInfo = banInfo + "\n" + Messages.bannedItemEdit;
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedMod + banreason, arguments)}).onClick((ClickAction)TextActions.runCommand((String)("/restrict edit " + mod.getMod()))).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                } else {
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedMod + banreason, arguments)}).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                }
                contents.add(send.build());
            }
            for (ItemData item : items) {
                if (item.getHidden().booleanValue()) continue;
                arguments = new HashMap();
                arguments.put("banreason", item.getBanreason());
                arguments.put("itemid", item.getItemid());
                arguments.put("usebanned", item.getUsagebanned().toString());
                arguments.put("breakbanned", item.getBreakingbanned().toString());
                arguments.put("placebanned", item.getPlacingbanned().toString());
                arguments.put("ownbanned", item.getOwnershipbanned().toString());
                arguments.put("craftbanned", item.getCraftbanned().toString());
                arguments.put("worldbanned", item.getWorldbanned().toString());
                arguments.put("itemname", item.getItemname());
                arguments.put("hidden", item.getHidden() != false ? "show" : "hide");
                send = Text.builder();
                banreason = "";
                if (!item.getBanreason().isEmpty()) {
                    banreason = Messages.bannedItemReason;
                }
                if (src.hasPermission("mmcrestrict.hidden.edit")) {
                    send.append(new Text[]{Text.builder().append(new Text[]{Messages.parseMessage(Messages.bannedListHide, arguments)}).onClick((ClickAction)TextActions.executeCallback(this.changeHidden(item.getItemid()))).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(Messages.bannedListHideHover, arguments))).build()});
                    send.append(new Text[]{this.plugin.fromLegacy(" ")});
                }
                banInfo = Messages.bannedItemHover;
                if (src.hasPermission("mmcrestrict.extra.list") && src.hasPermission("mmcrestrict.commands.edit")) {
                    banInfo = banInfo + "\n" + Messages.bannedItemExtraInfo + "\n" + Messages.bannedItemEdit;
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedItem + banreason, arguments)}).onClick((ClickAction)TextActions.runCommand((String)("/restrict edit " + item.getItemid()))).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                } else if (src.hasPermission("mmcrestrict.extra.list")) {
                    banInfo = banInfo + "\n" + Messages.bannedItemExtraInfo;
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedItem + banreason, arguments)}).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                } else if (src.hasPermission("mmcrestrict.commands.edit")) {
                    banInfo = banInfo + "\n" + Messages.bannedItemEdit;
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedItem + banreason, arguments)}).onClick((ClickAction)TextActions.runCommand((String)("/restrict edit " + item.getItemid()))).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                } else {
                    send.append(new Text[]{Messages.parseMessage(Messages.bannedItem + banreason, arguments)}).onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
                }
                contents.add(send.build());
            }
        }
        Text title = this.plugin.fromLegacy(Messages.bannedListTitle);
        if (contents.isEmpty()) {
            if (hidden.isPresent()) {
                contents.add(this.plugin.fromLegacy(Messages.bannedItemNonHidden));
                title = this.plugin.fromLegacy(Messages.bannedListHiddenTitle);
            } else {
                contents.add(this.plugin.fromLegacy(Messages.bannedItemNonSet));
            }
        }
        Collections.sort(contents);
        paginationService.builder().title(title).contents(contents).padding(this.plugin.fromLegacy(Messages.bannedListPadding)).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private Consumer<CommandSource> changeHidden(String itemID) {
        return consumer -> {
            ArrayList<ItemData> items = new ArrayList<ItemData>(this.plugin.getItemData());
            for (ItemData item : items) {
                if (!item.getItemid().equals(itemID)) continue;
                item.setHidden(item.getHidden() == false);
                String hidden = item.getHidden() != false ? "true" : "false";
                consumer.sendMessage(this.plugin.fromLegacy("&6" + itemID + " &2hidden set to: &6" + hidden));
            }
        };
    }

    private Consumer<CommandSource> changeHiddenMod(String modID) {
        return consumer -> {
            ArrayList<ModData> mods = new ArrayList<ModData>(this.plugin.getModData());
            for (ModData mod : mods) {
                if (!mod.getMod().equals(modID)) continue;
                mod.setHidden(mod.getHidden() == false);
                String hidden = mod.getHidden() != false ? "true" : "false";
                consumer.sendMessage(this.plugin.fromLegacy("&6" + modID + " &2hidden set to: &6" + hidden));
            }
        };
    }
}

