/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command;

import com.universeguard.region.LocalRegion;
import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;

public class RegionCopyExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (args.hasAny("name") && args.hasAny("newRegion")) {
            Region region = RegionUtils.load((String)args.getOne("name").get());
            if (region != null) {
                if (region.isLocal()) {
                    String newRegion = (String)args.getOne("newRegion").get();
                    if (RegionUtils.load(newRegion) == null) {
                        if (RegionUtils.save(RegionUtils.copy((LocalRegion)region, newRegion))) {
                            MessageUtils.sendSuccessMessage(src, RegionText.REGION_COPIED.getValue());
                        } else {
                            MessageUtils.sendErrorMessage(src, RegionText.REGION_NOT_COPIED.getValue());
                        }
                    } else {
                        MessageUtils.sendErrorMessage(src, RegionText.REGION_NAME_NOT_VALID.getValue());
                    }
                } else {
                    MessageUtils.sendErrorMessage(src, RegionText.REGION_LOCAL_ONLY.getValue());
                }
            } else {
                MessageUtils.sendErrorMessage(src, RegionText.REGION_NOT_FOUND.getValue());
            }
        } else {
            MessageUtils.sendErrorMessage(src, this.getCommandUsage());
        }
        return CommandResult.empty();
    }

    private String getCommandUsage() {
        return "/rg copy <Region1> <Region2>";
    }
}

