/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command;

import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;

public class RegionNameExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (RegionUtils.hasPendingRegion(src)) {
            if (args.hasAny("name")) {
                String name = (String)args.getOne("name").get();
                if (RegionUtils.load(name) == null) {
                    Region region = RegionUtils.getPendingRegion(src);
                    region.setName(name);
                    MessageUtils.sendSuccessMessage(src, RegionText.REGION_NAME_UPDATED.getValue());
                    RegionUtils.updatePendingRegion(src, region);
                } else {
                    MessageUtils.sendErrorMessage(src, RegionText.REGION_NAME_NOT_VALID.getValue());
                }
            } else {
                MessageUtils.sendErrorMessage(src, this.getCommandUsage());
            }
        } else {
            MessageUtils.sendErrorMessage(src, RegionText.NO_PENDING_REGION.getValue());
        }
        return CommandResult.empty();
    }

    private String getCommandUsage() {
        return "/rg name <value>";
    }
}

