/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command.argument;

import com.universeguard.command.argument.RegionNameElement;
import com.universeguard.region.LocalRegion;
import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionPermission;
import com.universeguard.utils.LogUtils;
import com.universeguard.utils.PermissionUtils;
import com.universeguard.utils.RegionUtils;
import java.util.ArrayList;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.PatternMatchingCommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;

public class RegionOwnedNameElement
extends PatternMatchingCommandElement {
    public RegionOwnedNameElement(Text key) {
        super(key);
    }

    protected Iterable<String> getChoices(CommandSource source) {
        ArrayList<String> regions = new ArrayList<String>();
        if (source instanceof Player) {
            Player player = (Player)source;
            if (PermissionUtils.hasPermission(player, RegionPermission.REGION)) {
                return new RegionNameElement(this.getKey()).getChoices(source);
            }
            for (Region region : RegionUtils.getPlayerRegions(player)) {
                LocalRegion localRegion;
                if (!region.isLocal() || !(localRegion = (LocalRegion)region).getOwner().getUUID().equals(player.getUniqueId()) && !localRegion.getOwner().getUsername().equalsIgnoreCase(player.getName())) continue;
                regions.add(localRegion.getName());
            }
        }
        LogUtils.log(String.join((CharSequence)",", regions));
        return regions;
    }

    protected Object getValue(String choice) throws IllegalArgumentException {
        return choice;
    }
}

