/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.utils;

import com.universeguard.region.enums.RegionPermission;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.entity.living.player.Player;

public class PermissionUtils {
    public static void setDefaultValues(CommentedConfigurationNode configNode) {
        for (RegionPermission permission : RegionPermission.values()) {
            if (!configNode.getNode(new Object[]{"permissions", permission.getName()}).isVirtual()) continue;
            configNode.getNode(new Object[]{"permissions", permission.getName()}).setValue((Object)permission.getValue()).setComment(permission.getComment());
        }
    }

    public static void getValues(CommentedConfigurationNode configNode) {
        for (RegionPermission permission : RegionPermission.values()) {
            permission.setValue(configNode.getNode(new Object[]{"permissions", permission.getName()}).getString());
        }
    }

    public static boolean hasPermission(Player player, RegionPermission permission) {
        return PermissionUtils.hasAllPermissions(player) || player.hasPermission(permission.getValue());
    }

    public static boolean hasAllPermissions(Player player) {
        return player.hasPermission("*") || player.hasPermission(RegionPermission.ALL.getValue()) || player.hasPermission("universeguard.*");
    }
}

