/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.bulkupdate;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.bulkupdate.DataType;
import me.lucko.luckperms.common.bulkupdate.action.Action;
import me.lucko.luckperms.common.bulkupdate.query.Query;

public class BulkUpdateBuilder {
    private DataType dataType = DataType.ALL;
    private Action action = null;
    private boolean trackStatistics = false;
    private final Set<Query> queries = new LinkedHashSet<Query>();

    public static BulkUpdateBuilder create() {
        return new BulkUpdateBuilder();
    }

    private BulkUpdateBuilder() {
    }

    public BulkUpdateBuilder action(Action action) {
        this.action = action;
        return this;
    }

    public BulkUpdateBuilder dataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public BulkUpdateBuilder trackStatistics(boolean trackStatistics) {
        this.trackStatistics = trackStatistics;
        return this;
    }

    public BulkUpdateBuilder query(Query query) {
        this.queries.add(query);
        return this;
    }

    public BulkUpdate build() {
        if (this.action == null) {
            throw new IllegalStateException("no action specified");
        }
        return new BulkUpdate(this.dataType, this.action, (List<Query>)ImmutableList.copyOf(this.queries), this.trackStatistics);
    }

    public String toString() {
        return "BulkUpdateBuilder(dataType=" + (Object)((Object)this.dataType) + ", action=" + this.action + ", constraints=" + this.queries + ", trackStatistics=" + this.trackStatistics + ")";
    }
}

