/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.spec;

import java.util.Arrays;
import java.util.List;
import me.lucko.luckperms.common.command.spec.Argument;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.TranslatableComponent;

public enum CommandSpec {
    USER("/%s user <user>", new PartialArgument[0]),
    GROUP("/%s group <group>", new PartialArgument[0]),
    TRACK("/%s track <track>", new PartialArgument[0]),
    LOG("/%s log", new PartialArgument[0]),
    SYNC("/%s sync", new PartialArgument[0]),
    INFO("/%s info", new PartialArgument[0]),
    EDITOR("/%s editor [type]", CommandSpec.arg("type", false), CommandSpec.arg("filter", false)),
    VERBOSE("/%s verbose <on|record|off|upload> [filter]", CommandSpec.arg("action", "on|record|off|upload|command", true), CommandSpec.arg("filter", false), CommandSpec.arg("commandas", "<me|player> <command>", false)),
    TREE("/%s tree [scope] [player]", CommandSpec.arg("scope", false), CommandSpec.arg("player", false)),
    SEARCH("/%s search <permission>", CommandSpec.arg("permission", true), CommandSpec.arg("page", false)),
    NETWORK_SYNC("/%s networksync", new PartialArgument[0]),
    IMPORT("/%s import <file>", CommandSpec.arg("file", true), CommandSpec.arg("replace", "--replace", false), CommandSpec.arg("upload", "--upload", false)),
    EXPORT("/%s export <file>", CommandSpec.arg("file", true), CommandSpec.arg("without-users", "--without-users", false), CommandSpec.arg("without-groups", "--without-groups", false), CommandSpec.arg("upload", "--upload", false)),
    RELOAD_CONFIG("/%s reloadconfig", new PartialArgument[0]),
    BULK_UPDATE("/%s bulkupdate", CommandSpec.arg("data type", true), CommandSpec.arg("action", true), CommandSpec.arg("action field", false), CommandSpec.arg("action value", false), CommandSpec.arg("constraint...", false)),
    TRANSLATIONS("/%s translations", CommandSpec.arg("install", false)),
    APPLY_EDITS("/%s applyedits <code> [target]", CommandSpec.arg("code", true), CommandSpec.arg("target", false)),
    CREATE_GROUP("/%s creategroup <group>", CommandSpec.arg("name", true), CommandSpec.arg("weight", false), CommandSpec.arg("display-name", "displayname", false)),
    DELETE_GROUP("/%s deletegroup <group>", CommandSpec.arg("name", true)),
    LIST_GROUPS("/%s listgroups", new PartialArgument[0]),
    CREATE_TRACK("/%s createtrack <track>", CommandSpec.arg("name", true)),
    DELETE_TRACK("/%s deletetrack <track>", CommandSpec.arg("name", true)),
    LIST_TRACKS("/%s listtracks", new PartialArgument[0]),
    USER_INFO(new PartialArgument[0]),
    USER_SWITCHPRIMARYGROUP(CommandSpec.arg("group", true)),
    USER_PROMOTE(CommandSpec.arg("track", false), CommandSpec.arg("context...", false), CommandSpec.arg("dont-add-to-first", "--dont-add-to-first", false)),
    USER_DEMOTE(CommandSpec.arg("track", false), CommandSpec.arg("context...", false), CommandSpec.arg("dont-remove-from-first", "--dont-remove-from-first", false)),
    USER_CLONE(CommandSpec.arg("user", true)),
    GROUP_INFO(new PartialArgument[0]),
    GROUP_LISTMEMBERS(CommandSpec.arg("page", false)),
    GROUP_SETWEIGHT(CommandSpec.arg("weight", true)),
    GROUP_SET_DISPLAY_NAME(CommandSpec.arg("name", true), CommandSpec.arg("context...", false)),
    GROUP_RENAME(CommandSpec.arg("name", true)),
    GROUP_CLONE(CommandSpec.arg("name", true)),
    HOLDER_EDITOR(new PartialArgument[0]),
    HOLDER_SHOWTRACKS(new PartialArgument[0]),
    HOLDER_CLEAR(CommandSpec.arg("context...", false)),
    PERMISSION(new PartialArgument[0]),
    PARENT(new PartialArgument[0]),
    META(new PartialArgument[0]),
    PERMISSION_INFO(CommandSpec.arg("page", false), CommandSpec.arg("sort mode", false)),
    PERMISSION_SET(CommandSpec.arg("node", true), CommandSpec.arg("value", "true|false", false), CommandSpec.arg("context...", false)),
    PERMISSION_UNSET(CommandSpec.arg("node", true), CommandSpec.arg("context...", false)),
    PERMISSION_SETTEMP(CommandSpec.arg("node", true), CommandSpec.arg("value", "true|false", false), CommandSpec.arg("duration", true), CommandSpec.arg("temporary modifier", false), CommandSpec.arg("context...", false)),
    PERMISSION_UNSETTEMP(CommandSpec.arg("node", true), CommandSpec.arg("duration", false), CommandSpec.arg("context...", false)),
    PERMISSION_CHECK(CommandSpec.arg("node", true)),
    PERMISSION_CLEAR(CommandSpec.arg("context...", false)),
    PARENT_INFO(CommandSpec.arg("page", false), CommandSpec.arg("sort mode", false)),
    PARENT_SET(CommandSpec.arg("group", true), CommandSpec.arg("context...", false)),
    PARENT_ADD(CommandSpec.arg("group", true), CommandSpec.arg("context...", false)),
    PARENT_REMOVE(CommandSpec.arg("group", true), CommandSpec.arg("context...", false)),
    PARENT_SET_TRACK(CommandSpec.arg("track", true), CommandSpec.arg("group", true), CommandSpec.arg("context...", false)),
    PARENT_ADD_TEMP(CommandSpec.arg("group", true), CommandSpec.arg("duration", true), CommandSpec.arg("temporary modifier", false), CommandSpec.arg("context...", false)),
    PARENT_REMOVE_TEMP(CommandSpec.arg("group", true), CommandSpec.arg("duration", false), CommandSpec.arg("context...", false)),
    PARENT_CLEAR(CommandSpec.arg("context...", false)),
    PARENT_CLEAR_TRACK(CommandSpec.arg("track", true), CommandSpec.arg("context...", false)),
    META_INFO(new PartialArgument[0]),
    META_SET(CommandSpec.arg("key", true), CommandSpec.arg("value", true), CommandSpec.arg("context...", false)),
    META_UNSET(CommandSpec.arg("key", true), CommandSpec.arg("context...", false)),
    META_SETTEMP(CommandSpec.arg("key", true), CommandSpec.arg("value", true), CommandSpec.arg("duration", true), CommandSpec.arg("context...", false)),
    META_UNSETTEMP(CommandSpec.arg("key", true), CommandSpec.arg("context...", false)),
    META_ADDPREFIX(CommandSpec.arg("priority", true), CommandSpec.arg("prefix", true), CommandSpec.arg("context...", false)),
    META_ADDSUFFIX(CommandSpec.arg("priority", true), CommandSpec.arg("suffix", true), CommandSpec.arg("context...", false)),
    META_SETPREFIX(CommandSpec.arg("priority", false), CommandSpec.arg("prefix", true), CommandSpec.arg("context...", false)),
    META_SETSUFFIX(CommandSpec.arg("priority", false), CommandSpec.arg("suffix", true), CommandSpec.arg("context...", false)),
    META_REMOVEPREFIX(CommandSpec.arg("priority", true), CommandSpec.arg("prefix", false), CommandSpec.arg("context...", false)),
    META_REMOVESUFFIX(CommandSpec.arg("priority", true), CommandSpec.arg("suffix", false), CommandSpec.arg("context...", false)),
    META_ADDTEMP_PREFIX(CommandSpec.arg("priority", true), CommandSpec.arg("prefix", true), CommandSpec.arg("duration", true), CommandSpec.arg("context...", false)),
    META_ADDTEMP_SUFFIX(CommandSpec.arg("priority", true), CommandSpec.arg("suffix", true), CommandSpec.arg("duration", true), CommandSpec.arg("context...", false)),
    META_SETTEMP_PREFIX(CommandSpec.arg("priority", true), CommandSpec.arg("prefix", true), CommandSpec.arg("duration", true), CommandSpec.arg("context...", false)),
    META_SETTEMP_SUFFIX(CommandSpec.arg("priority", true), CommandSpec.arg("suffix", true), CommandSpec.arg("duration", true), CommandSpec.arg("context...", false)),
    META_REMOVETEMP_PREFIX(CommandSpec.arg("priority", true), CommandSpec.arg("prefix", false), CommandSpec.arg("context...", false)),
    META_REMOVETEMP_SUFFIX(CommandSpec.arg("priority", true), CommandSpec.arg("suffix", false), CommandSpec.arg("context...", false)),
    META_CLEAR(CommandSpec.arg("type", false), CommandSpec.arg("context...", false)),
    TRACK_INFO(new PartialArgument[0]),
    TRACK_EDITOR(new PartialArgument[0]),
    TRACK_APPEND(CommandSpec.arg("group", true)),
    TRACK_INSERT(CommandSpec.arg("group", true), CommandSpec.arg("position", true)),
    TRACK_REMOVE(CommandSpec.arg("group", true)),
    TRACK_CLEAR(new PartialArgument[0]),
    TRACK_RENAME(CommandSpec.arg("name", true)),
    TRACK_CLONE(CommandSpec.arg("name", true)),
    LOG_RECENT(CommandSpec.arg("user", false), CommandSpec.arg("page", false)),
    LOG_SEARCH(CommandSpec.arg("query", true), CommandSpec.arg("page", false)),
    LOG_NOTIFY(CommandSpec.arg("toggle", "on|off", false)),
    LOG_USER_HISTORY(CommandSpec.arg("user", true), CommandSpec.arg("page", false)),
    LOG_GROUP_HISTORY(CommandSpec.arg("group", true), CommandSpec.arg("page", false)),
    LOG_TRACK_HISTORY(CommandSpec.arg("track", true), CommandSpec.arg("page", false)),
    SPONGE("/%s sponge <collection> <subject>", CommandSpec.arg("collection", true), CommandSpec.arg("subject", true)),
    SPONGE_PERMISSION_INFO(CommandSpec.arg("contexts...", false)),
    SPONGE_PERMISSION_SET(CommandSpec.arg("node", true), CommandSpec.arg("tristate", true), CommandSpec.arg("contexts...", false)),
    SPONGE_PERMISSION_CLEAR(CommandSpec.arg("contexts...", false)),
    SPONGE_PARENT_INFO(CommandSpec.arg("contexts...", false)),
    SPONGE_PARENT_ADD(CommandSpec.arg("collection", true), CommandSpec.arg("subject", true), CommandSpec.arg("contexts...", false)),
    SPONGE_PARENT_REMOVE(CommandSpec.arg("collection", true), CommandSpec.arg("subject", true), CommandSpec.arg("contexts...", false)),
    SPONGE_PARENT_CLEAR(CommandSpec.arg("contexts...", false)),
    SPONGE_OPTION_INFO(CommandSpec.arg("contexts...", false)),
    SPONGE_OPTION_SET(CommandSpec.arg("key", true), CommandSpec.arg("value", true), CommandSpec.arg("contexts...", false)),
    SPONGE_OPTION_UNSET(CommandSpec.arg("key", true), CommandSpec.arg("contexts...", false)),
    SPONGE_OPTION_CLEAR(CommandSpec.arg("contexts...", false));

    private final String usage;
    private final List<Argument> args;

    private CommandSpec(String usage, PartialArgument ... args) {
        this.usage = usage;
        this.args = args.length == 0 ? null : (List)Arrays.stream(args).map(builder -> {
            String key = ((PartialArgument)builder).id.replace(".", "").replace(' ', '-');
            TranslatableComponent description = Component.translatable((String)("luckperms.usage." + this.key() + ".argument." + key));
            return new Argument(((PartialArgument)builder).name, ((PartialArgument)builder).required, (Component)description);
        }).collect(ImmutableCollectors.toList());
    }

    private CommandSpec(PartialArgument ... args) {
        this((String)null, args);
    }

    public Component description() {
        return Component.translatable((String)("luckperms.usage." + this.key() + ".description"));
    }

    public String usage() {
        return this.usage;
    }

    public List<Argument> args() {
        return this.args;
    }

    public String key() {
        return this.name().toLowerCase().replace('_', '-');
    }

    private static PartialArgument arg(String id, String name, boolean required) {
        return new PartialArgument(id, name, required);
    }

    private static PartialArgument arg(String name, boolean required) {
        return new PartialArgument(name, name, required);
    }

    private static final class PartialArgument {
        private final String id;
        private final String name;
        private final boolean required;

        private PartialArgument(String id, String name, boolean required) {
            this.id = id;
            this.name = name;
            this.required = required;
        }
    }
}

