/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.other;

import java.util.ArrayList;
import java.util.Collections;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.node.matcher.StandardNodeMatchers;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.webeditor.WebEditorRequest;
import net.luckperms.api.context.ContextSet;

public class HolderEditor<T extends PermissionHolder>
extends ChildCommand<T> {
    public HolderEditor(HolderType type) {
        super(CommandSpec.HOLDER_EDITOR, "editor", type == HolderType.USER ? CommandPermission.USER_EDITOR : CommandPermission.GROUP_EDITOR, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, T target, ArgumentList args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), target) || ArgumentPermissions.checkGroup(plugin, sender, target, (ContextSet)ImmutableContextSetImpl.EMPTY)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        ArrayList<PermissionHolder> holders = new ArrayList<PermissionHolder>();
        if (target instanceof Group) {
            Group group = (Group)target;
            ConstraintNodeMatcher<String> matcher = StandardNodeMatchers.key(Inheritance.key(group.getName()));
            WebEditorRequest.includeMatchingUsers(holders, matcher, true, plugin);
        }
        holders.add((PermissionHolder)target);
        holders.removeIf(h -> ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), h) || ArgumentPermissions.checkGroup(plugin, sender, h, (ContextSet)ImmutableContextSetImpl.EMPTY));
        if (holders.isEmpty()) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        Message.EDITOR_START.send(sender);
        return WebEditorRequest.generate(holders, Collections.emptyList(), sender, label, plugin).createSession(plugin, sender);
    }
}

