/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import me.lucko.luckperms.common.backup.Exporter;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;

public class ExportCommand
extends SingleCommand {
    private final AtomicBoolean running = new AtomicBoolean(false);

    public ExportCommand() {
        super(CommandSpec.EXPORT, "Export", CommandPermission.EXPORT, Predicates.notInRange(1, 2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, ArgumentList args, String label) {
        Exporter exporter;
        if (this.running.get()) {
            Message.EXPORT_ALREADY_RUNNING.send(sender);
            return CommandResult.STATE_ERROR;
        }
        boolean includeUsers = !args.remove("--without-users");
        boolean includeGroups = !args.remove("--without-groups");
        boolean upload = args.remove("--upload");
        if (upload) {
            if (!this.running.compareAndSet(false, true)) {
                Message.EXPORT_ALREADY_RUNNING.send(sender);
                return CommandResult.STATE_ERROR;
            }
            exporter = new Exporter.WebUpload(plugin, sender, includeUsers, includeGroups, label);
        } else {
            Path dataDirectory = plugin.getBootstrap().getDataDirectory();
            Path path = dataDirectory.resolve(args.get(0) + ".json.gz");
            if (!path.getParent().equals(dataDirectory)) {
                Message.FILE_NOT_WITHIN_DIRECTORY.send(sender, path.toString());
                return CommandResult.INVALID_ARGS;
            }
            if (Files.exists(path, new LinkOption[0])) {
                Message.EXPORT_FILE_ALREADY_EXISTS.send(sender, path.toString());
                return CommandResult.INVALID_ARGS;
            }
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                Message.EXPORT_FILE_FAILURE.send(sender);
                plugin.getLogger().warn("Error whilst writing to the file", e);
                return CommandResult.FAILURE;
            }
            if (!Files.isWritable(path)) {
                Message.EXPORT_FILE_NOT_WRITABLE.send(sender, path.toString());
                return CommandResult.FAILURE;
            }
            if (!this.running.compareAndSet(false, true)) {
                Message.EXPORT_ALREADY_RUNNING.send(sender);
                return CommandResult.STATE_ERROR;
            }
            exporter = new Exporter.SaveFile(plugin, sender, path, includeUsers, includeGroups);
        }
        plugin.getBootstrap().getScheduler().executeAsync(() -> {
            try {
                exporter.run();
            }
            finally {
                this.running.set(false);
            }
        });
        return CommandResult.SUCCESS;
    }
}

