/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.user;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.track.PromotionResult;

public class UserPromote
extends ChildCommand<User> {
    public UserPromote() {
        super(CommandSpec.USER_PROMOTE, "promote", CommandPermission.USER_PROMOTE, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, User target, ArgumentList args, String label) throws CommandException {
        String trackName;
        boolean addToFirst;
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        boolean bl = addToFirst = !args.remove("--dont-add-to-first");
        if (args.isEmpty()) {
            Set tracks = plugin.getTrackManager().getAll().keySet();
            if (tracks.size() == 1) {
                args.add((String)tracks.iterator().next());
            } else if (tracks.contains("default")) {
                args.add("default");
            } else {
                Message.USER_TRACK_ERROR_AMBIGUOUS_TRACK_SELECTION.send(sender);
                return CommandResult.INVALID_ARGS;
            }
        }
        if (!DataConstraints.TRACK_NAME_TEST.test(trackName = args.get(0).toLowerCase())) {
            Message.TRACK_INVALID_ENTRY.send(sender, trackName);
            return CommandResult.INVALID_ARGS;
        }
        Track track = StorageAssistant.loadTrack(trackName, sender, plugin);
        if (track == null) {
            return CommandResult.LOADING_ERROR;
        }
        if (track.getSize() <= 1) {
            Message.TRACK_EMPTY.send(sender, track.getName());
            return CommandResult.STATE_ERROR;
        }
        boolean dontShowTrackProgress = args.remove("-s");
        MutableContextSet context = args.getContextOrDefault(1, plugin);
        if (ArgumentPermissions.checkContext(plugin, sender, this.getPermission().get(), context)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        Predicate<String> nextGroupPermissionChecker = s -> !ArgumentPermissions.checkArguments(plugin, sender, this.getPermission().get(), track.getName(), s) && !ArgumentPermissions.checkGroup(plugin, sender, s, (ContextSet)context);
        PromotionResult result = track.promote(target, context, nextGroupPermissionChecker, sender, addToFirst);
        switch (result.getStatus()) {
            case MALFORMED_TRACK: {
                Message.USER_PROMOTE_ERROR_MALFORMED.send(sender, result.getGroupTo().get());
                return CommandResult.LOADING_ERROR;
            }
            case UNDEFINED_FAILURE: {
                Message.COMMAND_NO_PERMISSION.send(sender);
                return CommandResult.NO_PERMISSION;
            }
            case AMBIGUOUS_CALL: {
                Message.TRACK_AMBIGUOUS_CALL.send(sender, target);
                return CommandResult.FAILURE;
            }
            case END_OF_TRACK: {
                Message.USER_PROMOTE_ERROR_ENDOFTRACK.send(sender, track.getName(), target);
                return CommandResult.STATE_ERROR;
            }
            case ADDED_TO_FIRST_GROUP: {
                if (!addToFirst && !result.getGroupTo().isPresent()) {
                    Message.USER_PROMOTE_NOT_ON_TRACK.send(sender, target, track.getName());
                    return CommandResult.STATE_ERROR;
                }
                Message.USER_TRACK_ADDED_TO_FIRST.send(sender, target, track.getName(), result.getGroupTo().get(), context);
                LoggedAction.build().source(sender).target(target).description("promote", track.getName(), context).build().submit(plugin, sender);
                StorageAssistant.save(target, sender, plugin);
                return CommandResult.SUCCESS;
            }
            case SUCCESS: {
                String groupFrom = result.getGroupFrom().get();
                String groupTo = result.getGroupTo().get();
                Message.USER_PROMOTE_SUCCESS.send(sender, target, track.getName(), groupFrom, groupTo, context);
                if (!dontShowTrackProgress) {
                    Message.TRACK_PATH_HIGHLIGHTED_PROGRESSION.send(sender, track.getGroups(), groupFrom, groupTo, false);
                }
                LoggedAction.build().source(sender).target(target).description("promote", track.getName(), context).build().submit(plugin, sender);
                StorageAssistant.save(target, sender, plugin);
                return CommandResult.SUCCESS;
            }
        }
        throw new AssertionError((Object)("Unknown status: " + result.getStatus()));
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().at(0, TabCompletions.tracks(plugin)).from(1, TabCompletions.contexts(plugin)).complete((List<String>)((Object)args));
    }
}

