/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context;

import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.cache.ExpiringCache;
import me.lucko.luckperms.common.context.ContextManager;
import me.lucko.luckperms.common.context.QueryOptionsSupplier;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class QueryOptionsCache<T>
extends ExpiringCache<QueryOptions>
implements QueryOptionsSupplier {
    private final T subject;
    private final ContextManager<T, ?> contextManager;

    public QueryOptionsCache(T subject, ContextManager<T, ?> contextManager) {
        super(50L, TimeUnit.MILLISECONDS);
        this.subject = subject;
        this.contextManager = contextManager;
    }

    @Override
    protected @NonNull QueryOptions supply() {
        return this.contextManager.calculate(this.subject);
    }

    @Override
    public QueryOptions getQueryOptions() {
        return (QueryOptions)this.get();
    }

    @Override
    public ImmutableContextSet getContextSet() {
        return ((QueryOptions)this.get()).context();
    }
}

