/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.dependencies;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gson.JsonElement;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.dependencies.Dependency;
import me.lucko.luckperms.common.dependencies.relocation.Relocation;
import me.lucko.luckperms.common.dependencies.relocation.RelocationHandler;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.StorageType;
import net.luckperms.api.platform.Platform;

public class DependencyRegistry {
    private static final ListMultimap<StorageType, Dependency> STORAGE_DEPENDENCIES = ImmutableListMultimap.builder().putAll((Object)StorageType.YAML, (Object[])new Dependency[]{Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_YAML}).putAll((Object)StorageType.JSON, (Object[])new Dependency[]{Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_GSON}).putAll((Object)StorageType.HOCON, (Object[])new Dependency[]{Dependency.HOCON_CONFIG, Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_HOCON}).putAll((Object)StorageType.TOML, (Object[])new Dependency[]{Dependency.TOML4J, Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_TOML}).putAll((Object)StorageType.YAML_COMBINED, (Object[])new Dependency[]{Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_YAML}).putAll((Object)StorageType.JSON_COMBINED, (Object[])new Dependency[]{Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_GSON}).putAll((Object)StorageType.HOCON_COMBINED, (Object[])new Dependency[]{Dependency.HOCON_CONFIG, Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_HOCON}).putAll((Object)StorageType.TOML_COMBINED, (Object[])new Dependency[]{Dependency.TOML4J, Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_TOML}).putAll((Object)StorageType.MONGODB, (Object[])new Dependency[]{Dependency.MONGODB_DRIVER}).putAll((Object)StorageType.MARIADB, (Object[])new Dependency[]{Dependency.MARIADB_DRIVER, Dependency.SLF4J_API, Dependency.SLF4J_SIMPLE, Dependency.HIKARI}).putAll((Object)StorageType.MYSQL, (Object[])new Dependency[]{Dependency.MYSQL_DRIVER, Dependency.SLF4J_API, Dependency.SLF4J_SIMPLE, Dependency.HIKARI}).putAll((Object)StorageType.POSTGRESQL, (Object[])new Dependency[]{Dependency.POSTGRESQL_DRIVER, Dependency.SLF4J_API, Dependency.SLF4J_SIMPLE, Dependency.HIKARI}).putAll((Object)StorageType.SQLITE, (Object[])new Dependency[]{Dependency.SQLITE_DRIVER}).putAll((Object)StorageType.H2, (Object[])new Dependency[]{Dependency.H2_DRIVER}).build();
    private final LuckPermsPlugin plugin;

    public DependencyRegistry(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    public Set<Dependency> resolveStorageDependencies(Set<StorageType> storageTypes) {
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        for (StorageType storageType : storageTypes) {
            dependencies.addAll(STORAGE_DEPENDENCIES.get((Object)storageType));
        }
        if (this.plugin.getConfiguration().get(ConfigKeys.REDIS_ENABLED).booleanValue()) {
            dependencies.add(Dependency.COMMONS_POOL_2);
            dependencies.add(Dependency.JEDIS);
            dependencies.add(Dependency.SLF4J_API);
            dependencies.add(Dependency.SLF4J_SIMPLE);
        }
        if (this.plugin.getConfiguration().get(ConfigKeys.RABBITMQ_ENABLED).booleanValue()) {
            dependencies.add(Dependency.RABBITMQ);
        }
        if ((dependencies.contains((Object)Dependency.SLF4J_API) || dependencies.contains((Object)Dependency.SLF4J_SIMPLE)) && DependencyRegistry.slf4jPresent()) {
            dependencies.remove((Object)Dependency.SLF4J_API);
            dependencies.remove((Object)Dependency.SLF4J_SIMPLE);
        }
        return dependencies;
    }

    public void applyRelocationSettings(Dependency dependency, List<Relocation> relocations) {
        Platform.Type type = this.plugin.getBootstrap().getType();
        if (!RelocationHandler.DEPENDENCIES.contains((Object)dependency) && JsonElement.class.getName().startsWith("me.lucko")) {
            relocations.add(Relocation.of("guava", "com{}google{}common"));
            relocations.add(Relocation.of("gson", "com{}google{}gson"));
        }
        if (dependency == Dependency.CONFIGURATE_YAML && type == Platform.Type.VELOCITY) {
            relocations.add(Relocation.of("yaml", "org{}yaml{}snakeyaml"));
        }
    }

    public boolean shouldAutoLoad(Dependency dependency) {
        switch (dependency) {
            case ASM: 
            case ASM_COMMONS: 
            case JAR_RELOCATOR: 
            case H2_DRIVER: 
            case SQLITE_DRIVER: {
                return false;
            }
        }
        return true;
    }

    private static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean slf4jPresent() {
        return DependencyRegistry.classExists("org.slf4j.Logger") && DependencyRegistry.classExists("org.slf4j.LoggerFactory");
    }
}

