/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.inheritance;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.graph.Graph;
import me.lucko.luckperms.common.graph.TraversalAlgorithm;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.query.QueryOptions;

public class InheritanceGraph
implements Graph<PermissionHolder> {
    private final LuckPermsPlugin plugin;
    private final QueryOptions queryOptions;

    public InheritanceGraph(LuckPermsPlugin plugin, QueryOptions queryOptions) {
        this.plugin = plugin;
        this.queryOptions = queryOptions;
    }

    @Override
    public Iterable<? extends PermissionHolder> successors(PermissionHolder holder) {
        LinkedHashSet<Group> successors = new LinkedHashSet<Group>();
        for (InheritanceNode n : holder.getOwnInheritanceNodes(this.queryOptions)) {
            Group g = (Group)this.plugin.getGroupManager().getIfLoaded(n.getGroupName());
            if (g == null) continue;
            successors.add(g);
        }
        ArrayList<? super PermissionHolder> successorsSorted = new ArrayList<PermissionHolder>(successors);
        successorsSorted.sort(holder.getInheritanceComparator());
        return successorsSorted;
    }

    public Iterable<PermissionHolder> traverse(TraversalAlgorithm algorithm, boolean postTraversalSort, PermissionHolder startNode) {
        Iterable<PermissionHolder> traversal = this.traverse(algorithm, startNode);
        if (postTraversalSort) {
            ArrayList<PermissionHolder> resolvedTraversal = new ArrayList<PermissionHolder>();
            for (PermissionHolder node : traversal) {
                resolvedTraversal.add(node);
            }
            resolvedTraversal.sort(startNode.getInheritanceComparator());
            traversal = resolvedTraversal;
        }
        return traversal;
    }

    public Iterable<PermissionHolder> traverse(PermissionHolder startNode) {
        return this.traverse(this.plugin.getConfiguration().get(ConfigKeys.INHERITANCE_TRAVERSAL_ALGORITHM), this.plugin.getConfiguration().get(ConfigKeys.POST_TRAVERSAL_INHERITANCE_SORT), startNode);
    }
}

