/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import me.lucko.luckperms.common.api.implementation.ApiGroup;
import me.lucko.luckperms.common.cache.Cache;
import me.lucko.luckperms.common.cacheddata.GroupCachedDataManager;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.WeightCache;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.TextComponent;
import me.lucko.luckperms.lib.adventure.text.format.NamedTextColor;
import me.lucko.luckperms.lib.adventure.text.format.TextColor;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.DisplayNameNode;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Group
extends PermissionHolder {
    private final ApiGroup apiProxy = new ApiGroup(this);
    private final String name;
    private final Cache<OptionalInt> weightCache = new WeightCache(this);
    private final Cache<Optional<String>> displayNameCache = new DisplayNameCache();
    private final GroupCachedDataManager cachedData;

    public Group(String name, LuckPermsPlugin plugin) {
        super(plugin);
        this.name = name.toLowerCase();
        this.cachedData = new GroupCachedDataManager(this);
        this.getPlugin().getEventDispatcher().dispatchGroupCacheLoad(this, this.cachedData);
    }

    @Override
    protected void invalidateCache() {
        super.invalidateCache();
        this.weightCache.invalidate();
        this.displayNameCache.invalidate();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getObjectName() {
        return this.name;
    }

    public ApiGroup getApiProxy() {
        return this.apiProxy;
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.getPlugin().getContextManager().getStaticQueryOptions();
    }

    public GroupCachedDataManager getCachedData() {
        return this.cachedData;
    }

    @Override
    public Component getFormattedDisplayName() {
        String displayName = this.getDisplayName().orElse(null);
        if (displayName != null) {
            return ((TextComponent.Builder)((TextComponent.Builder)Component.text().content(this.name).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Message.OPEN_BRACKET)).append((Component)Component.text((String)displayName))).append((Component)Message.CLOSE_BRACKET))).build();
        }
        return Component.text((String)this.name);
    }

    @Override
    public String getPlainDisplayName() {
        return this.getDisplayName().orElse(this.getName());
    }

    public Optional<String> getDisplayName() {
        return this.displayNameCache.get();
    }

    public Optional<String> calculateDisplayName(QueryOptions queryOptions) {
        Iterator<DisplayNameNode> iterator = this.getOwnNodes(NodeType.DISPLAY_NAME, queryOptions).iterator();
        if (iterator.hasNext()) {
            DisplayNameNode n = iterator.next();
            return Optional.of(n.getDisplayName());
        }
        String name = this.getPlugin().getConfiguration().get(ConfigKeys.GROUP_NAME_REWRITES).get(this.name);
        return name == null || name.equals(this.name) ? Optional.empty() : Optional.of(name);
    }

    @Override
    public OptionalInt getWeight() {
        return this.weightCache.get();
    }

    @Override
    public HolderType getType() {
        return HolderType.GROUP;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group other = (Group)o;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Group(name=" + this.name + ")";
    }

    public class DisplayNameCache
    extends Cache<Optional<String>> {
        @Override
        protected @NonNull Optional<String> supply() {
            return Group.this.calculateDisplayName(Group.this.getPlugin().getContextManager().getStaticQueryOptions());
        }
    }
}

