/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.matcher;

import me.lucko.luckperms.common.bulkupdate.comparison.Constraint;
import me.lucko.luckperms.common.bulkupdate.comparison.StandardComparison;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.node.types.DisplayName;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.node.types.Meta;
import me.lucko.luckperms.common.node.types.RegexPermission;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.MetaNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StandardNodeMatchers {
    private StandardNodeMatchers() {
    }

    public static ConstraintNodeMatcher<Node> of(Constraint constraint) {
        return new Generic(constraint);
    }

    public static ConstraintNodeMatcher<Node> key(String key) {
        return new Generic(Constraint.of(StandardComparison.EQUAL, key));
    }

    public static <T extends Node> ConstraintNodeMatcher<T> key(T node) {
        return new NodeEquals<T>(node, NodeEqualityPredicate.ONLY_KEY);
    }

    public static ConstraintNodeMatcher<Node> keyStartsWith(String startsWith) {
        return new Generic(Constraint.of(StandardComparison.SIMILAR, startsWith + "%"));
    }

    public static <T extends Node> ConstraintNodeMatcher<T> equals(T other, NodeEqualityPredicate equalityPredicate) {
        return new NodeEquals<T>(other, equalityPredicate);
    }

    public static ConstraintNodeMatcher<MetaNode> metaKey(String metaKey) {
        return new MetaKeyEquals(metaKey);
    }

    public static <T extends Node> ConstraintNodeMatcher<T> type(NodeType<? extends T> type) {
        return new TypeEquals<T>(type);
    }

    private static final class TypeEquals<T extends Node>
    extends ConstraintNodeMatcher<T> {
        private final NodeType<? extends T> type;

        protected TypeEquals(NodeType<? extends T> type) {
            super(TypeEquals.getConstraintForType(type));
            this.type = type;
        }

        @Override
        public @Nullable T filterConstraintMatch(@NonNull Node node) {
            return (T)((Node)this.type.tryCast(node).orElse(null));
        }

        private static Constraint getConstraintForType(NodeType<?> type) {
            if (type == NodeType.REGEX_PERMISSION) {
                return Constraint.of(StandardComparison.SIMILAR, RegexPermission.key("%"));
            }
            if (type == NodeType.INHERITANCE) {
                return Constraint.of(StandardComparison.SIMILAR, Inheritance.key("%"));
            }
            if (type == NodeType.PREFIX) {
                return Constraint.of(StandardComparison.SIMILAR, "prefix.%.%");
            }
            if (type == NodeType.SUFFIX) {
                return Constraint.of(StandardComparison.SIMILAR, "suffix.%.%");
            }
            if (type == NodeType.META) {
                return Constraint.of(StandardComparison.SIMILAR, Meta.key("%", "%"));
            }
            if (type == NodeType.WEIGHT) {
                return Constraint.of(StandardComparison.SIMILAR, "weight.%");
            }
            if (type == NodeType.DISPLAY_NAME) {
                return Constraint.of(StandardComparison.SIMILAR, DisplayName.key("%"));
            }
            throw new IllegalArgumentException("Unable to create a NodeMatcher for NodeType " + type.name());
        }
    }

    private static final class MetaKeyEquals
    extends ConstraintNodeMatcher<MetaNode> {
        MetaKeyEquals(String metaKey) {
            super(Constraint.of(StandardComparison.SIMILAR, Meta.key(metaKey, "%")));
        }

        @Override
        public @Nullable MetaNode filterConstraintMatch(@NonNull Node node) {
            return NodeType.META.tryCast(node).orElse(null);
        }
    }

    private static final class NodeEquals<T extends Node>
    extends ConstraintNodeMatcher<T> {
        private final T node;
        private final NodeEqualityPredicate equalityPredicate;

        NodeEquals(T node, NodeEqualityPredicate equalityPredicate) {
            super(Constraint.of(StandardComparison.EQUAL, node.getKey()));
            this.node = node;
            this.equalityPredicate = equalityPredicate;
        }

        @Override
        public @Nullable T filterConstraintMatch(@NonNull Node node) {
            if (this.equalityPredicate == NodeEqualityPredicate.ONLY_KEY || this.node.equals(node, this.equalityPredicate)) {
                return (T)node;
            }
            return null;
        }
    }

    private static class Generic
    extends ConstraintNodeMatcher<Node> {
        Generic(Constraint constraint) {
            super(constraint);
        }

        @Override
        public @Nullable Node filterConstraintMatch(@NonNull Node node) {
            return node;
        }
    }
}

