/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.query;

import java.util.Comparator;
import net.luckperms.api.model.PermissionHolder;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.query.dataorder.DataQueryOrder;
import net.luckperms.api.query.dataorder.DataQueryOrderFunction;
import net.luckperms.api.query.dataorder.DataTypeFilter;
import net.luckperms.api.query.dataorder.DataTypeFilterFunction;

public final class DataSelector {
    private static final DataType[] TRANSIENT_NORMAL = new DataType[]{DataType.TRANSIENT, DataType.NORMAL};
    private static final DataType[] NORMAL_TRANSIENT = new DataType[]{DataType.NORMAL, DataType.TRANSIENT};
    private static final DataType[] NORMAL = new DataType[]{DataType.NORMAL};
    private static final DataType[] TRANSIENT = new DataType[]{DataType.TRANSIENT};
    private static final DataType[] NONE = new DataType[0];

    private DataSelector() {
    }

    public static DataType[] selectOrder(QueryOptions queryOptions, PermissionHolder.Identifier identifier) {
        DataQueryOrderFunction orderFunc = queryOptions.option(DataQueryOrderFunction.KEY).orElse(null);
        DataTypeFilterFunction filterFunc = queryOptions.option(DataTypeFilterFunction.KEY).orElse(null);
        if (orderFunc == null && filterFunc == null) {
            return TRANSIENT_NORMAL;
        }
        DataTypeFilter predicate = filterFunc != null ? filterFunc.getTypeFilter(identifier) : DataTypeFilter.ALL;
        boolean normal = predicate.test(DataType.NORMAL);
        boolean trans = predicate.test(DataType.TRANSIENT);
        if (normal && trans) {
            Comparator<DataType> comparator = orderFunc != null ? orderFunc.getOrderComparator(identifier) : DataQueryOrder.TRANSIENT_FIRST;
            int compare = comparator.compare(DataType.TRANSIENT, DataType.NORMAL);
            if (compare == 0) {
                throw new IllegalStateException("Comparator " + comparator + " does not define an order between DataType.NORMAL and DataType.TRANSIENT!");
            }
            return compare > 0 ? TRANSIENT_NORMAL : NORMAL_TRANSIENT;
        }
        if (normal) {
            return NORMAL;
        }
        if (trans) {
            return TRANSIENT;
        }
        return NONE;
    }
}

