/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.sponge.commands.SpongeCommandUtils;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;

public class ParentInfo
extends ChildCommand<LPSubjectData> {
    public ParentInfo() {
        super(CommandSpec.SPONGE_PARENT_INFO, "info", CommandPermission.SPONGE_PARENT_INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, LPSubjectData subjectData, ArgumentList args, String label) {
        ImmutableContextSet contextSet = args.getContextOrEmpty(0);
        if (contextSet.isEmpty()) {
            SpongeCommandUtils.sendPrefixed(sender, "&aShowing parents matching contexts &bANY&a.");
            ImmutableMap<ImmutableContextSet, ImmutableList<LPSubjectReference>> parents = subjectData.getAllParents();
            if (parents.isEmpty()) {
                SpongeCommandUtils.sendPrefixed(sender, "That subject does not have any parents defined.");
                return CommandResult.SUCCESS;
            }
            for (Map.Entry e : parents.entrySet()) {
                SpongeCommandUtils.sendPrefixed(sender, "&3>> &bContext: " + SpongeCommandUtils.contextToString((ContextSet)e.getKey()) + "\n" + SpongeCommandUtils.parentsToString((Iterable)e.getValue()));
            }
        } else {
            ImmutableList<LPSubjectReference> parents = subjectData.getParents(contextSet);
            if (parents.isEmpty()) {
                SpongeCommandUtils.sendPrefixed(sender, "That subject does not have any parents defined in those contexts.");
                return CommandResult.SUCCESS;
            }
            SpongeCommandUtils.sendPrefixed(sender, "&aShowing parents matching contexts &b" + SpongeCommandUtils.contextToString(contextSet) + "&a.\n" + SpongeCommandUtils.parentsToString(parents));
        }
        return CommandResult.SUCCESS;
    }
}

