/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.abstraction.Command;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import me.lucko.luckperms.sponge.commands.OptionClear;
import me.lucko.luckperms.sponge.commands.OptionInfo;
import me.lucko.luckperms.sponge.commands.OptionSet;
import me.lucko.luckperms.sponge.commands.OptionUnset;
import me.lucko.luckperms.sponge.commands.ParentAdd;
import me.lucko.luckperms.sponge.commands.ParentClear;
import me.lucko.luckperms.sponge.commands.ParentInfo;
import me.lucko.luckperms.sponge.commands.ParentRemove;
import me.lucko.luckperms.sponge.commands.PermissionClear;
import me.lucko.luckperms.sponge.commands.PermissionInfo;
import me.lucko.luckperms.sponge.commands.PermissionSet;
import me.lucko.luckperms.sponge.commands.SpongeCommandUtils;
import me.lucko.luckperms.sponge.service.LuckPermsService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;

public class SpongeParentCommand
extends Command<Void> {
    private final LPSpongePlugin plugin;
    private final Map<String, List<ChildCommand<LPSubjectData>>> children = ImmutableMap.builder().put((Object)"permission", (Object)ImmutableList.builder().add((Object)new PermissionInfo()).add((Object)new PermissionSet()).add((Object)new PermissionClear()).build()).put((Object)"parent", (Object)ImmutableList.builder().add((Object)new ParentInfo()).add((Object)new ParentAdd()).add((Object)new ParentRemove()).add((Object)new ParentClear()).build()).put((Object)"option", (Object)ImmutableList.builder().add((Object)new OptionInfo()).add((Object)new OptionSet()).add((Object)new OptionUnset()).add((Object)new OptionClear()).build()).build();

    public SpongeParentCommand(LPSpongePlugin plugin) {
        super(CommandSpec.SPONGE, "Sponge", null, Predicates.alwaysFalse());
        this.plugin = plugin;
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Void v, ArgumentList args, String label) {
        CommandResult result;
        String type;
        LuckPermsService service = this.plugin.getService();
        if (args.size() < 1) {
            SpongeCommandUtils.sendPrefixed(sender, "&aCurrent Subject Collections:\n" + SpongeCommandUtils.toCommaSep(service.getLoadedCollections().keySet().stream().filter(s -> !s.equalsIgnoreCase("user") && !s.equalsIgnoreCase("group")).sorted().collect(Collectors.toList())));
            return CommandResult.SUCCESS;
        }
        String subjectCollection = args.get(0);
        if (subjectCollection.equalsIgnoreCase("user") || subjectCollection.equalsIgnoreCase("group")) {
            SpongeCommandUtils.sendPrefixed(sender, "Please use the main LuckPerms commands to edit users and groups.");
            return CommandResult.STATE_ERROR;
        }
        if (service.getLoadedCollections().keySet().stream().map(String::toLowerCase).noneMatch(s -> s.equalsIgnoreCase(subjectCollection))) {
            SpongeCommandUtils.sendPrefixed(sender, "Warning: SubjectCollection '&4" + subjectCollection + "&c' doesn't already exist. Creating it now.");
        }
        LPSubjectCollection collection = service.getCollection(subjectCollection);
        if (args.size() < 2) {
            List<String> subjects = collection.getLoadedSubjects().stream().map(LPSubject::getIdentifier).collect(Collectors.toList());
            if (subjects.size() > 50) {
                List extra = subjects.subList(50, subjects.size());
                int overflow = extra.size();
                extra.clear();
                SpongeCommandUtils.sendPrefixed(sender, "&aCurrent Subjects:\n" + SpongeCommandUtils.toCommaSep(subjects) + "&b ... and &a" + overflow + " &bmore.");
            } else {
                SpongeCommandUtils.sendPrefixed(sender, "&aCurrent Subjects:\n" + SpongeCommandUtils.toCommaSep(subjects));
            }
            return CommandResult.SUCCESS;
        }
        if (args.size() < 4) {
            this.sendDetailedUsage(sender, label);
            return CommandResult.SUCCESS;
        }
        boolean persistent = true;
        if (args.get(2).toLowerCase().startsWith("-t")) {
            persistent = false;
            args.remove(2);
        }
        if (!((type = args.get(2).toLowerCase()).equals("permission") || type.equals("parent") || type.equals("option"))) {
            this.sendDetailedUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        String cmd = args.get(3);
        ChildCommand sub = this.children.get(type).stream().filter(s -> s.getName().equalsIgnoreCase(cmd)).findAny().orElse(null);
        if (sub == null) {
            this.sendDetailedUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        if (!sub.isAuthorized(sender)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        if (sub.getArgumentCheck().test(args.size() - 4)) {
            sub.sendDetailedUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        String subjectId = args.get(1);
        if (!collection.hasRegistered(subjectId).join().booleanValue()) {
            SpongeCommandUtils.sendPrefixed(sender, "Warning: Subject '&4" + subjectId + "&c' doesn't already exist. Creating it now.");
        }
        LPSubject subject = collection.loadSubject(subjectId).join();
        LPSubjectData subjectData = persistent ? subject.getSubjectData() : subject.getTransientSubjectData();
        try {
            result = sub.execute(plugin, sender, subjectData, args.subList(4, args.size()), label);
        }
        catch (CommandException e) {
            result = e.handle(sender, label, sub);
        }
        return result;
    }

    @Override
    public void sendUsage(Sender sender, String label) {
        SpongeCommandUtils.sendPrefixed(sender, "&3> &a" + String.format(this.getUsage(), label));
    }

    @Override
    public void sendDetailedUsage(Sender sender, String label) {
        SpongeCommandUtils.sendPrefixed(sender, "&b" + this.getName() + " Sub Commands: &7(" + String.format("/%s sponge <collection> <subject> [-transient]", label) + " ...)");
        for (String s : Arrays.asList("Permission", "Parent", "Option")) {
            List subs = this.children.get(s.toLowerCase()).stream().filter(sub -> sub.isAuthorized(sender)).collect(Collectors.toList());
            if (subs.isEmpty()) continue;
            SpongeCommandUtils.sendPrefixed(sender, "&3>>  &b" + s);
            for (Command sub2 : subs) {
                sub2.sendUsage(sender, label);
            }
        }
    }

    @Override
    public boolean isAuthorized(Sender sender) {
        return this.children.values().stream().flatMap(Collection::stream).anyMatch(sc -> sc.isAuthorized(sender));
    }
}

