/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.model.persisted;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import me.lucko.luckperms.common.cache.LoadingMap;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.sponge.service.LuckPermsService;
import me.lucko.luckperms.sponge.service.ProxyFactory;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import me.lucko.luckperms.sponge.service.model.persisted.PersistedSubject;
import me.lucko.luckperms.sponge.service.model.persisted.SubjectDataContainer;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.util.Tristate;
import org.spongepowered.api.service.permission.SubjectCollection;

public class PersistedCollection
implements LPSubjectCollection {
    private final LuckPermsService service;
    private final String identifier;
    private final boolean isDefaultsCollection;
    private final SubjectCollection spongeProxy;
    private final Map<String, PersistedSubject> subjects = LoadingMap.of(s -> new PersistedSubject(this.getService(), this, (String)s));

    public PersistedCollection(LuckPermsService service, String identifier) {
        this.service = service;
        this.identifier = identifier;
        this.isDefaultsCollection = identifier.equals("defaults");
        this.spongeProxy = ProxyFactory.toSponge(this);
    }

    public void loadAll() {
        Map<String, SubjectDataContainer> holders = this.service.getStorage().loadAllFromFile(this.identifier);
        for (Map.Entry<String, SubjectDataContainer> e : holders.entrySet()) {
            PersistedSubject subject = this.subjects.get(e.getKey().toLowerCase());
            if (subject == null) continue;
            subject.loadData(e.getValue());
        }
    }

    @Override
    public SubjectCollection sponge() {
        return this.spongeProxy;
    }

    @Override
    public LuckPermsService getService() {
        return this.service;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public Predicate<String> getIdentifierValidityPredicate() {
        return Predicates.alwaysTrue();
    }

    @Override
    public boolean isDefaultsCollection() {
        return this.isDefaultsCollection;
    }

    public LPSubject obtainSubject(String identifier) {
        return this.subjects.get(identifier.toLowerCase());
    }

    @Override
    @Deprecated
    public CompletableFuture<LPSubject> loadSubject(String identifier) {
        return CompletableFuture.completedFuture(this.obtainSubject(identifier));
    }

    @Override
    @Deprecated
    public Optional<LPSubject> getSubject(String identifier) {
        return Optional.of(Objects.requireNonNull(this.obtainSubject(identifier)));
    }

    @Override
    public CompletableFuture<Boolean> hasRegistered(String identifier) {
        return CompletableFuture.completedFuture(this.subjects.containsKey(identifier.toLowerCase()));
    }

    @Override
    public CompletableFuture<ImmutableCollection<LPSubject>> loadSubjects(Set<String> identifiers) {
        ImmutableSet.Builder subjects = ImmutableSet.builder();
        for (String id : identifiers) {
            subjects.add((Object)Objects.requireNonNull(this.subjects.get(id.toLowerCase())));
        }
        return CompletableFuture.completedFuture(subjects.build());
    }

    @Override
    public ImmutableCollection<LPSubject> getLoadedSubjects() {
        return ImmutableList.copyOf(this.subjects.values());
    }

    @Override
    public CompletableFuture<ImmutableSet<String>> getAllIdentifiers() {
        return CompletableFuture.completedFuture(ImmutableSet.copyOf(this.subjects.keySet()));
    }

    @Override
    public CompletableFuture<ImmutableMap<LPSubjectReference, Boolean>> getAllWithPermission(String permission) {
        return CompletableFuture.completedFuture(this.getLoadedWithPermission(permission).entrySet().stream().collect(ImmutableCollectors.toMap(e -> ((LPSubject)e.getKey()).toReference(), Map.Entry::getValue)));
    }

    @Override
    public CompletableFuture<ImmutableMap<LPSubjectReference, Boolean>> getAllWithPermission(ImmutableContextSet contexts, String permission) {
        return CompletableFuture.completedFuture(this.getLoadedWithPermission(contexts, permission).entrySet().stream().collect(ImmutableCollectors.toMap(e -> ((LPSubject)e.getKey()).toReference(), Map.Entry::getValue)));
    }

    @Override
    public ImmutableMap<LPSubject, Boolean> getLoadedWithPermission(String permission) {
        ImmutableMap.Builder m = ImmutableMap.builder();
        for (LPSubject lPSubject : this.subjects.values()) {
            Tristate ts = lPSubject.getPermissionValue(ImmutableContextSetImpl.EMPTY, permission);
            if (ts == Tristate.UNDEFINED) continue;
            m.put((Object)lPSubject, (Object)ts.asBoolean());
        }
        return m.build();
    }

    @Override
    public ImmutableMap<LPSubject, Boolean> getLoadedWithPermission(ImmutableContextSet contexts, String permission) {
        ImmutableMap.Builder m = ImmutableMap.builder();
        for (LPSubject lPSubject : this.subjects.values()) {
            Tristate ts = lPSubject.getPermissionValue(contexts, permission);
            if (ts == Tristate.UNDEFINED) continue;
            m.put((Object)lPSubject, (Object)ts.asBoolean());
        }
        return m.build();
    }

    @Override
    public LPSubject getDefaults() {
        return this.service.getDefaultSubjects().getTypeDefaults(this.getIdentifier());
    }
}

