/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.reference;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.util.CaffeineFactory;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import me.lucko.luckperms.sponge.service.model.ProxiedSubject;
import me.lucko.luckperms.sponge.service.reference.CachedSubjectReference;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectReference;

public final class SubjectReferenceFactory {
    private final LPPermissionService service;
    private final LoadingCache<SubjectReferenceAttributes, CachedSubjectReference> referenceCache;

    public SubjectReferenceFactory(LPPermissionService service) {
        this.service = service;
        this.referenceCache = CaffeineFactory.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build(a -> new CachedSubjectReference(this.service, ((SubjectReferenceAttributes)a).collectionId, ((SubjectReferenceAttributes)a).id));
    }

    @Deprecated
    public LPSubjectReference deserialize(String serializedReference) {
        Objects.requireNonNull(serializedReference, "serializedReference");
        List parts = Splitter.on((char)'/').limit(2).splitToList((CharSequence)serializedReference);
        return this.obtain((String)parts.get(0), (String)parts.get(1));
    }

    public LPSubjectReference obtain(LPSubject subject) {
        Objects.requireNonNull(subject, "subject");
        LPSubjectReference reference = this.obtain(subject.getParentCollection().getIdentifier(), subject.getIdentifier());
        ((CachedSubjectReference)reference).fillCache(subject);
        return reference;
    }

    public LPSubjectReference obtain(Subject subject) {
        Objects.requireNonNull(subject, "subject");
        if (subject instanceof ProxiedSubject) {
            return ((ProxiedSubject)subject).asSubjectReference();
        }
        return this.obtain(subject.getContainingCollection().getIdentifier(), subject.getIdentifier());
    }

    public LPSubjectReference obtain(SubjectReference reference) {
        Objects.requireNonNull(reference, "reference");
        if (reference instanceof LPSubjectReference) {
            return (LPSubjectReference)reference;
        }
        return this.obtain(reference.getCollectionIdentifier(), reference.getSubjectIdentifier());
    }

    public LPSubjectReference obtain(String collectionIdentifier, String subjectIdentifier) {
        Objects.requireNonNull(collectionIdentifier, "collectionIdentifier");
        Objects.requireNonNull(subjectIdentifier, "subjectIdentifier");
        return (LPSubjectReference)this.referenceCache.get((Object)new SubjectReferenceAttributes(collectionIdentifier, subjectIdentifier));
    }

    private static final class SubjectReferenceAttributes {
        private final String collectionId;
        private final String id;
        private final int hashCode;

        private SubjectReferenceAttributes(String collectionId, String id) {
            this.collectionId = collectionId.toLowerCase();
            this.id = id.toLowerCase();
            this.hashCode = this.calculateHashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubjectReferenceAttributes)) {
                return false;
            }
            SubjectReferenceAttributes other = (SubjectReferenceAttributes)o;
            return this.collectionId.equals(other.collectionId) && this.id.equals(other.id);
        }

        private int calculateHashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.collectionId.hashCode();
            result = result * 59 + this.id.hashCode();
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

