/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.upgrade;

import WayofTime.bloodmagic.livingArmour.ILivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.util.helper.TextHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class LivingArmourUpgradePoisonResist
extends LivingArmourUpgrade {
    public static final int[] costs = new int[]{2, 6, 14, 25, 40};
    public static final int[] poisonCooldownTime = new int[]{1200, 800, 600, 300, 100};
    public static final int[] poisonMaxCure = new int[]{0, 1, 2, 2, 3};
    public int poisonCooldown = 0;

    public LivingArmourUpgradePoisonResist(int level) {
        super(level);
    }

    @Override
    public void onTick(World world, EntityPlayer player, ILivingArmour livingArmour) {
        if (player.func_70644_a(MobEffects.field_76436_u) && this.poisonCooldown <= 0) {
            PotionEffect eff = player.func_70660_b(MobEffects.field_76436_u);
            if (eff.func_76458_c() <= poisonMaxCure[this.level]) {
                player.func_184589_d(MobEffects.field_76436_u);
                this.poisonCooldown = poisonCooldownTime[this.level];
                player.func_146105_b((ITextComponent)new TextComponentString(TextHelper.localize(chatBase + "poisonRemove", new Object[0])), true);
            }
        } else if (this.poisonCooldown > 0) {
            --this.poisonCooldown;
        }
    }

    @Override
    public String getUniqueIdentifier() {
        return "bloodmagic.upgrade.poisonResist";
    }

    @Override
    public int getMaxTier() {
        return 5;
    }

    @Override
    public int getCostOfUpgrade() {
        return costs[this.level];
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("poisonTimer", this.poisonCooldown);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.poisonCooldown = tag.func_74762_e("poisonTimer");
    }

    @Override
    public String getTranslationKey() {
        return tooltipBase + "poisonResist";
    }
}

