/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.help.Help;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandUseMapFeatures
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world usemapfeatures").get();

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        String bool;
        String worldName;
        if (arguments.equalsIgnoreCase("usemapfeatures")) {
            throw new CommandException(this.help.getUsageText());
        }
        String[] args = arguments.split(" ");
        if (args[args.length - 1].equalsIgnoreCase("--help")) {
            this.help.execute(source);
            return CommandResult.success();
        }
        try {
            worldName = args[0];
        }
        catch (Exception e) {
            throw new CommandException(this.help.getUsageText());
        }
        try {
            bool = args[1];
        }
        catch (Exception e) {
            throw new CommandException(this.help.getUsageText());
        }
        Optional optionalWorld = Sponge.getServer().getWorldProperties(worldName);
        if (!optionalWorld.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, worldName, " does not exist"}), false);
        }
        WorldProperties world = (WorldProperties)optionalWorld.get();
        if (bool.equalsIgnoreCase("true") || bool.equalsIgnoreCase("false")) {
            world.setMapFeaturesEnabled(Boolean.valueOf(bool).booleanValue());
        }
        Sponge.getServer().saveWorldProperties(world);
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Set use map features of ", world.getWorldName(), " to ", TextColors.YELLOW, bool}));
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("usemapfeatures")) {
            return list;
        }
        String[] args = arguments.split(" ");
        if (args.length == 1) {
            for (WorldProperties world : Sponge.getServer().getAllWorldProperties()) {
                if (world.getWorldName().equalsIgnoreCase(args[0])) {
                    list.add("true");
                    list.add("false");
                    return list;
                }
                if (!world.getWorldName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(world.getWorldName());
            }
            return list;
        }
        if (args.length == 2) {
            if ("true".equalsIgnoreCase(args[1].toLowerCase()) || "false".equalsIgnoreCase(args[1].toLowerCase())) {
                return list;
            }
            if ("true".startsWith(args[1].toLowerCase())) {
                list.add("true");
            }
            if ("false".startsWith(args[1].toLowerCase())) {
                list.add("false");
            }
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.help.getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.help.getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.help.getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.help.getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

