/*
 * Decompiled with CFR 0.152.
 */
package net.obnoxint.xnbt;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.obnoxint.xnbt.BaseTag;
import net.obnoxint.xnbt.BaseTagIOHandler;
import net.obnoxint.xnbt.GzipNBTInputStream;
import net.obnoxint.xnbt.GzipNBTOutputStream;
import net.obnoxint.xnbt.NBTInputStream;
import net.obnoxint.xnbt.NBTOutputStream;
import net.obnoxint.xnbt.Tag;
import net.obnoxint.xnbt.types.NBTTag;

public final class XNBT {
    private static final Map<Byte, TagPayloadReader> readers = new HashMap<Byte, TagPayloadReader>();
    private static final Map<Byte, TagBuilder> builders = new HashMap<Byte, TagBuilder>();
    private static final Map<Byte, TagPayloadWriter> writers = new HashMap<Byte, TagPayloadWriter>();

    public static void dump(List<NBTTag> tags, PrintStream out) throws Exception {
        for (NBTTag tag : tags) {
            XNBT.dump(0, tag, null, out);
        }
    }

    public static TagBuilder getBuilder(byte type) {
        return builders.get(type);
    }

    public static TagPayloadReader getReader(byte type) {
        return readers.get(type);
    }

    public static TagPayloadWriter getWriter(byte type) {
        return writers.get(type);
    }

    public static List<NBTTag> loadTags(File file) throws IOException {
        return XNBT.loadTags(file, true);
    }

    public static List<NBTTag> loadTags(File file, boolean isZipped) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            List<NBTTag> list = XNBT.readTags(is, isZipped);
            return list;
        }
    }

    public static List<NBTTag> readTags(InputStream is) throws IOException {
        return XNBT.readTags(is, true);
    }

    public static List<NBTTag> readTags(InputStream is, boolean isZipped) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("is must not be null");
        }
        ArrayList<NBTTag> r = new ArrayList<NBTTag>();
        try (NBTInputStream in = isZipped ? new GzipNBTInputStream(is) : new NBTInputStream(is);){
            NBTTag tag;
            while (!(tag = in.readTag()).equals(BaseTag.ENDTAG)) {
                r.add(tag);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return r;
    }

    public static void registerType(byte type, TagIOHandler handler) {
        XNBT.registerType(type, handler, handler, handler);
    }

    public static void registerType(byte type, TagPayloadReader reader, TagBuilder builder, TagPayloadWriter writer) {
        if (readers.containsKey(type)) {
            throw new IllegalArgumentException("type already registered: " + type);
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        if (builder == null) {
            throw new IllegalArgumentException("builder must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        readers.put(type, reader);
        builders.put(type, builder);
        writers.put(type, writer);
    }

    public static void saveTags(List<NBTTag> tags, File file) throws IOException {
        XNBT.saveTags(tags, file, true);
    }

    public static void saveTags(List<NBTTag> tags, File file, boolean zip) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file);){
            XNBT.writeTags(tags, os, zip);
        }
    }

    public static void unregisterType(byte type) {
        readers.remove(type);
        builders.remove(type);
        writers.remove(type);
    }

    public static void writeTags(List<NBTTag> tags, OutputStream os) throws IOException {
        XNBT.writeTags(tags, os, true);
    }

    public static void writeTags(List<NBTTag> tags, OutputStream os, boolean zip) throws IOException {
        if (tags == null) {
            throw new IllegalArgumentException("tags must not be null");
        }
        if (os == null) {
            throw new IllegalArgumentException("os must not be null");
        }
        if (tags.isEmpty()) {
            return;
        }
        if (tags.contains(null)) {
            throw new IllegalArgumentException("tags must not contain null elements");
        }
        if (tags.contains(BaseTag.ENDTAG)) {
            throw new IllegalArgumentException("tags must not contain end tags");
        }
        try (NBTOutputStream out = zip ? new GzipNBTOutputStream(new DataOutputStream(os)) : new NBTOutputStream(new DataOutputStream(os));){
            for (NBTTag t : tags) {
                out.writeTag(t);
            }
        }
    }

    static void dump(int depth, NBTTag tag, StringBuilder sb, PrintStream out) throws Exception {
        block17: {
            Object payload;
            block16: {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(XNBT.indent(depth));
                byte type = tag.getHeader().getType();
                String name = tag.getHeader().getName();
                payload = tag.getPayload();
                sb.append(type).append(" ").append(type < NBTTag.BaseType.values().length ? NBTTag.BaseType.byId(type).name() : XNBT.getBuilder(type).getClass().getName()).append(" ").append(name.isEmpty() ? "(untitled)" : name).append(" ");
                if (type >= NBTTag.BaseType.values().length) break block16;
                switch (NBTTag.BaseType.byId(type)) {
                    case XNBT: {
                        Object o = tag.getPayload();
                        if (!o.getClass().isAnnotationPresent(Tag.class)) break;
                        sb.append(o.getClass().getName()).append(" ").append("\"").append(o.getClass().getAnnotation(Tag.class).name()).append("\"");
                        for (Field f : o.getClass().getDeclaredFields()) {
                            if (!f.isAnnotationPresent(Tag.class)) continue;
                            f.setAccessible(true);
                            sb.append("\n").append(XNBT.indent(depth + 1)).append(f.getName()).append(" ").append(f.getType().getName()).append(" ").append("\"").append(f.getAnnotation(Tag.class).name()).append("\" ").append(f.get(o));
                            f.setAccessible(false);
                        }
                        break block17;
                    }
                    case END: {
                        sb.append("\n");
                        break;
                    }
                    case BYTE_ARRAY: {
                        sb.append(Arrays.toString((byte[])payload)).append("\n");
                        break;
                    }
                    case INTEGER_ARRAY: {
                        sb.append(Arrays.toString((int[])payload)).append("\n");
                        break;
                    }
                    case COMPOUND: {
                        Map _c = (Map)payload;
                        sb.append(_c.size()).append(" values");
                        if (!_c.isEmpty()) {
                            sb.append("\n");
                            for (NBTTag e : _c.values()) {
                                XNBT.dump(depth + 1, e, sb, null);
                            }
                        }
                        break block17;
                    }
                    case LIST: {
                        List _l = (List)payload;
                        sb.append(_l.size()).append(" values");
                        if (!_l.isEmpty()) {
                            sb.append("\n");
                            for (NBTTag e : _l) {
                                XNBT.dump(depth + 1, e, sb, null);
                            }
                        }
                        break block17;
                    }
                    case STRING: {
                        String s = (String)payload;
                        sb.append(s.isEmpty() ? "(empty string)" : s).append("\n");
                        break;
                    }
                    default: {
                        sb.append(payload).append("\n");
                        break;
                    }
                }
                break block17;
            }
            sb.append(payload.toString()).append("\n");
        }
        if (depth == 0) {
            out.println(sb.toString());
        }
    }

    static Map<Byte, TagBuilder> getBuilders() {
        return builders;
    }

    private static String indent(int depth) {
        int off = depth * 3;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < off; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private XNBT() {
    }

    static {
        for (byte i = 1; i < BaseTagIOHandler.getHandlers().length - 1; i = (byte)(i + 1)) {
            XNBT.registerType(i, BaseTagIOHandler.getHandlers()[i]);
        }
        XNBT.registerType(NBTTag.BaseType.XNBT.Id(), BaseTagIOHandler.xnbtHandler);
    }

    public static interface TagPayloadWriter {
        public void write(Object var1, NBTOutputStream var2) throws IOException;
    }

    public static interface TagPayloadReader {
        public Object read(NBTInputStream var1) throws IOException;
    }

    public static interface TagIOHandler
    extends TagBuilder,
    TagPayloadReader,
    TagPayloadWriter {
    }

    public static interface TagBuilder {
        public NBTTag build(byte var1, String var2, Object var3);
    }
}

