/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.api.entities;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.FactionChest;
import io.github.aquerr.eaglefactions.api.entities.FactionHome;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPermType;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.text.Text;

public interface Faction
extends Comparable<Faction> {
    public String getName();

    public Text getTag();

    public String getDescription();

    public String getMessageOfTheDay();

    public FactionHome getHome();

    public UUID getLeader();

    public Set<String> getTruces();

    public Set<String> getAlliances();

    public Set<Claim> getClaims();

    public Set<String> getEnemies();

    public Set<UUID> getMembers();

    public Set<UUID> getOfficers();

    public Set<UUID> getRecruits();

    public Set<UUID> getPlayers();

    public Map<FactionMemberType, Map<FactionPermType, Boolean>> getPerms();

    public Instant getLastOnline();

    public FactionMemberType getPlayerMemberType(UUID var1);

    public FactionChest getChest();

    public boolean isPublic();

    public boolean containsPlayer(UUID var1);

    default public boolean isSafeZone() {
        return this.getName().equalsIgnoreCase("safezone");
    }

    default public boolean isWarZone() {
        return this.getName().equalsIgnoreCase("warzone");
    }

    default public boolean isAlly(Faction faction) {
        return this.getAlliances().contains(faction.getName());
    }

    default public boolean isTruce(Faction faction) {
        return this.getTruces().contains(faction.getName());
    }

    default public boolean isEnemy(Faction faction) {
        return this.getEnemies().contains(faction.getName());
    }

    default public Optional<Claim> getClaimAt(UUID worldUUID, Vector3i chunkPosition) {
        for (Claim claim : this.getClaims()) {
            if (!claim.getWorldUUID().equals(worldUUID) || !claim.getChunkPosition().equals((Object)chunkPosition)) continue;
            return Optional.of(claim);
        }
        return Optional.empty();
    }

    public Builder toBuilder();

    public static interface Builder {
        public Builder setName(String var1);

        public Builder setTag(Text var1);

        public Builder setDescription(String var1);

        public Builder setMessageOfTheDay(String var1);

        public Builder setLeader(UUID var1);

        public Builder setRecruits(Set<UUID> var1);

        public Builder setMembers(Set<UUID> var1);

        public Builder setOfficers(Set<UUID> var1);

        public Builder setAlliances(Set<String> var1);

        public Builder setTruces(Set<String> var1);

        public Builder setEnemies(Set<String> var1);

        public Builder setClaims(Set<Claim> var1);

        public Builder setHome(FactionHome var1);

        public Builder setLastOnline(Instant var1);

        public Builder setPerms(Map<FactionMemberType, Map<FactionPermType, Boolean>> var1);

        public Builder setChest(FactionChest var1);

        public Builder setIsPublic(boolean var1);

        public Faction build();
    }
}

