/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.Configuration;
import io.github.aquerr.eaglefactions.api.entities.AllyRequest;
import io.github.aquerr.eaglefactions.api.entities.ArmisticeRequest;
import io.github.aquerr.eaglefactions.api.entities.ChatEnum;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.api.entities.Invite;
import io.github.aquerr.eaglefactions.api.logic.AttackLogic;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.api.logic.PVPLogger;
import io.github.aquerr.eaglefactions.api.managers.PermsManager;
import io.github.aquerr.eaglefactions.api.managers.PlayerManager;
import io.github.aquerr.eaglefactions.api.managers.PowerManager;
import io.github.aquerr.eaglefactions.api.managers.ProtectionManager;
import io.github.aquerr.eaglefactions.api.storage.StorageManager;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.VersionCommand;
import io.github.aquerr.eaglefactions.common.commands.access.AccessCommand;
import io.github.aquerr.eaglefactions.common.commands.access.AccessFactionCommand;
import io.github.aquerr.eaglefactions.common.commands.access.AccessPlayerCommand;
import io.github.aquerr.eaglefactions.common.commands.access.NotAccessibleByFactionCommand;
import io.github.aquerr.eaglefactions.common.commands.access.OwnedByCommand;
import io.github.aquerr.eaglefactions.common.commands.admin.DebugCommand;
import io.github.aquerr.eaglefactions.common.commands.admin.MaxPowerCommand;
import io.github.aquerr.eaglefactions.common.commands.admin.RegenCommand;
import io.github.aquerr.eaglefactions.common.commands.admin.ReloadCommand;
import io.github.aquerr.eaglefactions.common.commands.admin.SetPowerCommand;
import io.github.aquerr.eaglefactions.common.commands.args.BackupNameArgument;
import io.github.aquerr.eaglefactions.common.commands.args.FactionArgument;
import io.github.aquerr.eaglefactions.common.commands.args.FactionPlayerArgument;
import io.github.aquerr.eaglefactions.common.commands.args.OwnFactionPlayerArgument;
import io.github.aquerr.eaglefactions.common.commands.backup.BackupCommand;
import io.github.aquerr.eaglefactions.common.commands.backup.RestoreBackupCommand;
import io.github.aquerr.eaglefactions.common.commands.claiming.AutoClaimCommand;
import io.github.aquerr.eaglefactions.common.commands.claiming.ClaimCommand;
import io.github.aquerr.eaglefactions.common.commands.claiming.ClaimsListCommand;
import io.github.aquerr.eaglefactions.common.commands.claiming.SquareClaimCommand;
import io.github.aquerr.eaglefactions.common.commands.claiming.UnclaimAllCommand;
import io.github.aquerr.eaglefactions.common.commands.claiming.UnclaimCommand;
import io.github.aquerr.eaglefactions.common.commands.general.AttackCommand;
import io.github.aquerr.eaglefactions.common.commands.general.AutoMapCommand;
import io.github.aquerr.eaglefactions.common.commands.general.ChatCommand;
import io.github.aquerr.eaglefactions.common.commands.general.ChestCommand;
import io.github.aquerr.eaglefactions.common.commands.general.CoordsCommand;
import io.github.aquerr.eaglefactions.common.commands.general.EagleFeatherCommand;
import io.github.aquerr.eaglefactions.common.commands.general.HelpCommand;
import io.github.aquerr.eaglefactions.common.commands.general.HomeCommand;
import io.github.aquerr.eaglefactions.common.commands.general.InfoCommand;
import io.github.aquerr.eaglefactions.common.commands.general.InviteCommand;
import io.github.aquerr.eaglefactions.common.commands.general.JoinCommand;
import io.github.aquerr.eaglefactions.common.commands.general.KickCommand;
import io.github.aquerr.eaglefactions.common.commands.general.LeaveCommand;
import io.github.aquerr.eaglefactions.common.commands.general.ListCommand;
import io.github.aquerr.eaglefactions.common.commands.general.MapCommand;
import io.github.aquerr.eaglefactions.common.commands.general.PlayerCommand;
import io.github.aquerr.eaglefactions.common.commands.general.TopCommand;
import io.github.aquerr.eaglefactions.common.commands.management.CreateCommand;
import io.github.aquerr.eaglefactions.common.commands.management.DescriptionCommand;
import io.github.aquerr.eaglefactions.common.commands.management.DisbandCommand;
import io.github.aquerr.eaglefactions.common.commands.management.MotdCommand;
import io.github.aquerr.eaglefactions.common.commands.management.PermsCommand;
import io.github.aquerr.eaglefactions.common.commands.management.PublicCommand;
import io.github.aquerr.eaglefactions.common.commands.management.RenameCommand;
import io.github.aquerr.eaglefactions.common.commands.management.SetHomeCommand;
import io.github.aquerr.eaglefactions.common.commands.management.TagColorCommand;
import io.github.aquerr.eaglefactions.common.commands.management.TagCommand;
import io.github.aquerr.eaglefactions.common.commands.rank.DemoteCommand;
import io.github.aquerr.eaglefactions.common.commands.rank.PromoteCommand;
import io.github.aquerr.eaglefactions.common.commands.rank.SetLeaderCommand;
import io.github.aquerr.eaglefactions.common.commands.relation.AllyCommand;
import io.github.aquerr.eaglefactions.common.commands.relation.EnemyCommand;
import io.github.aquerr.eaglefactions.common.commands.relation.TruceCommand;
import io.github.aquerr.eaglefactions.common.config.ConfigurationImpl;
import io.github.aquerr.eaglefactions.common.entities.FactionImpl;
import io.github.aquerr.eaglefactions.common.entities.FactionPlayerImpl;
import io.github.aquerr.eaglefactions.common.integrations.bstats.Metrics;
import io.github.aquerr.eaglefactions.common.integrations.dynmap.DynmapService;
import io.github.aquerr.eaglefactions.common.integrations.placeholderapi.EFPlaceholderService;
import io.github.aquerr.eaglefactions.common.listeners.BlockBreakListener;
import io.github.aquerr.eaglefactions.common.listeners.BlockPlaceListener;
import io.github.aquerr.eaglefactions.common.listeners.ChatMessageListener;
import io.github.aquerr.eaglefactions.common.listeners.EntityDamageListener;
import io.github.aquerr.eaglefactions.common.listeners.EntitySpawnListener;
import io.github.aquerr.eaglefactions.common.listeners.ExplosionListener;
import io.github.aquerr.eaglefactions.common.listeners.ModifyBlockListener;
import io.github.aquerr.eaglefactions.common.listeners.NotifyNeighborBlockListener;
import io.github.aquerr.eaglefactions.common.listeners.PlayerDeathListener;
import io.github.aquerr.eaglefactions.common.listeners.PlayerDisconnectListener;
import io.github.aquerr.eaglefactions.common.listeners.PlayerInteractListener;
import io.github.aquerr.eaglefactions.common.listeners.PlayerJoinListener;
import io.github.aquerr.eaglefactions.common.listeners.PlayerMoveListener;
import io.github.aquerr.eaglefactions.common.listeners.SendCommandListener;
import io.github.aquerr.eaglefactions.common.listeners.faction.FactionJoinListener;
import io.github.aquerr.eaglefactions.common.listeners.faction.FactionKickListener;
import io.github.aquerr.eaglefactions.common.listeners.faction.FactionLeaveListener;
import io.github.aquerr.eaglefactions.common.logic.AttackLogicImpl;
import io.github.aquerr.eaglefactions.common.logic.FactionLogicImpl;
import io.github.aquerr.eaglefactions.common.logic.PVPLoggerImpl;
import io.github.aquerr.eaglefactions.common.managers.PermsManagerImpl;
import io.github.aquerr.eaglefactions.common.managers.PlayerManagerImpl;
import io.github.aquerr.eaglefactions.common.managers.PowerManagerImpl;
import io.github.aquerr.eaglefactions.common.managers.ProtectionManagerImpl;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsScheduler;
import io.github.aquerr.eaglefactions.common.scheduling.FactionRemoverTask;
import io.github.aquerr.eaglefactions.common.storage.StorageManagerImpl;
import io.github.aquerr.eaglefactions.common.storage.serializers.ClaimSetTypeSerializer;
import io.github.aquerr.eaglefactions.common.storage.serializers.ClaimTypeSerializer;
import io.github.aquerr.eaglefactions.common.version.VersionChecker;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.asset.AssetId;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Tristate;

@Plugin(id="eaglefactions", name="Eagle Factions", version="0.15.2_394-SNAPSHOT", description="A factions plugin that will make managing your battle-server easier. :)", authors={"Aquerr"}, dependencies={@Dependency(id="placeholderapi", optional=true)})
public class EagleFactionsPlugin
implements EagleFactions {
    public static final Map<List<String>, CommandSpec> SUBCOMMANDS = new HashMap<List<String>, CommandSpec>();
    public static final List<Invite> INVITE_LIST = new ArrayList<Invite>();
    public static final List<AllyRequest> TRUCE_INVITE_LIST = new ArrayList<AllyRequest>();
    public static final List<AllyRequest> ALLY_INVITE_LIST = new ArrayList<AllyRequest>();
    public static final List<ArmisticeRequest> ARMISTICE_REQUEST_LIST = new ArrayList<ArmisticeRequest>();
    public static final List<UUID> AUTO_CLAIM_LIST = new ArrayList<UUID>();
    public static final List<UUID> AUTO_MAP_LIST = new ArrayList<UUID>();
    public static final Map<UUID, String> REGEN_CONFIRMATION_MAP = new HashMap<UUID, String>();
    public static final Map<String, Integer> ATTACKED_FACTIONS = new HashMap<String, Integer>();
    public static final Map<UUID, Integer> BLOCKED_HOME = new HashMap<UUID, Integer>();
    public static final Map<UUID, ChatEnum> CHAT_LIST = new HashMap<UUID, ChatEnum>();
    public static final Map<UUID, Integer> HOME_COOLDOWN_PLAYERS = new HashMap<UUID, Integer>();
    public static final List<UUID> DEBUG_MODE_PLAYERS = new ArrayList<UUID>();
    private static EagleFactionsPlugin eagleFactions;
    private Configuration configuration;
    private PVPLogger pvpLogger;
    private PlayerManager playerManager;
    private PermsManager permsManager;
    private ProtectionManager protectionManager;
    private PowerManager powerManager;
    private AttackLogic attackLogic;
    private FactionLogic factionLogic;
    private StorageManager storageManager;
    @Inject
    @AssetId(value="Settings.conf")
    private Asset configAsset;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path configDir;
    @Inject
    private Metrics metrics;
    private EFPlaceholderService efPlaceholderService;
    private DynmapService dynmapService;

    public static EagleFactionsPlugin getPlugin() {
        return eagleFactions;
    }

    @Override
    public Path getConfigDir() {
        return this.configDir;
    }

    @Listener
    public void onServerInitialization(GameInitializationEvent event) {
        eagleFactions = this;
        this.registerTypeSerializers();
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.AQUA, "Preparing wings..."}));
        this.setupConfigs();
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.AQUA, "Configs loaded."}));
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.AQUA, "Loading managers and cache..."}));
        this.setupManagers();
        this.registerAPI();
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.AQUA, "Managers loaded."}));
        this.initializeCommands();
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.AQUA, "Commands loaded."}));
        this.registerListeners();
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "=========================================="}));
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.AQUA, "Eagle Factions", TextColors.WHITE, " is ready to use!"}));
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.WHITE, "Thank you for choosing this plugin!"}));
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.WHITE, "Current version: 0.15.2_394-SNAPSHOT"}));
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.WHITE, "Have a great time with Eagle Factions! :D"}));
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "=========================================="}));
        CompletableFuture.runAsync(() -> {
            if (!VersionChecker.isLatest("0.15.2_394-SNAPSHOT")) {
                Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, "Hey! A new version of ", TextColors.AQUA, "Eagle Factions", TextColors.GOLD, " is available online!"}));
                Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "=========================================="}));
            }
        });
    }

    private void registerTypeSerializers() {
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(Claim.class), (TypeSerializer)new ClaimTypeSerializer());
        TypeSerializers.getDefaultSerializers().registerType((TypeToken)new TypeToken<Set<Claim>>(){}, (TypeSerializer)new ClaimSetTypeSerializer());
    }

    private void registerAPI() {
        Sponge.getServiceManager().setProvider((Object)this, FactionLogic.class, (Object)this.factionLogic);
        Sponge.getServiceManager().setProvider((Object)this, PowerManager.class, (Object)this.powerManager);
        Sponge.getServiceManager().setProvider((Object)this, PlayerManager.class, (Object)this.playerManager);
        Sponge.getServiceManager().setProvider((Object)this, ProtectionManager.class, (Object)this.protectionManager);
        Sponge.getServiceManager().setProvider((Object)this, PermsManager.class, (Object)this.permsManager);
        Sponge.getServiceManager().setProvider((Object)this, PVPLogger.class, (Object)this.pvpLogger);
        Sponge.getServiceManager().setProvider((Object)this, AttackLogic.class, (Object)this.attackLogic);
    }

    @Listener
    public void onGameStarting(GameStartingServerEvent event) {
        try {
            Class<?> placeholderInterface = Class.forName("me.rojo8399.placeholderapi.PlaceholderService");
            Optional placeholderService1 = Sponge.getServiceManager().provide(placeholderInterface);
            placeholderService1.ifPresent(placeholderService -> {
                this.printInfo("Found PlaceholderAPI! Registering placeholders...");
                this.efPlaceholderService = EFPlaceholderService.getInstance(this, placeholderService);
                this.printInfo("Registered Eagle Factions' placeholders.");
            });
        }
        catch (ClassNotFoundException | NoClassDefFoundError error) {
            this.printInfo("PlaceholderAPI could not be found. Skipping addition of placeholders.");
        }
        this.setDefaultPermissions();
        if (this.configuration.getDynmapConfig().isDynmapIntegrationEnabled()) {
            try {
                Class.forName("org.dynmap.DynmapCommonAPI");
                this.dynmapService = new DynmapService(this);
                this.dynmapService.activate();
                this.printInfo("Dynmap Integration is active!");
            }
            catch (ClassNotFoundException error) {
                this.printInfo("Dynmap could not be found. Dynmap integration will not be available.");
            }
        }
    }

    public void setDefaultPermissions() {
        Optional optionalPermissionService = Sponge.getServiceManager().provide(PermissionService.class);
        if (optionalPermissionService.isPresent()) {
            PermissionService permissionService = (PermissionService)optionalPermissionService.get();
            Map permissionContext = permissionService.getDefaults().getSubjectData().getPermissions(SubjectData.GLOBAL_CONTEXT);
            boolean hasEagleFactionsPermission = false;
            for (String permission : permissionContext.keySet()) {
                if (!permission.contains("eaglefactions")) continue;
                hasEagleFactionsPermission = true;
                break;
            }
            if (!hasEagleFactionsPermission) {
                permissionService.getDefaults().getSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, "eaglefactions.player", Tristate.TRUE);
            }
        }
    }

    @Listener
    public void onGameLoad(GameStartedServerEvent event) {
        this.startFactionsRemover();
    }

    @Listener
    public void onReload(GameReloadEvent event) {
        this.configuration.reloadConfiguration();
        this.storageManager.reloadStorage();
        if (this.configuration.getDynmapConfig().isDynmapIntegrationEnabled()) {
            this.dynmapService.reload();
        }
        if (event.getSource() instanceof Player) {
            Player player = (Player)event.getSource();
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, Messages.CONFIG_HAS_BEEN_RELOADED}));
        }
    }

    private void initializeCommands() {
        SUBCOMMANDS.put(Collections.singletonList("help"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_HELP_DESC)).permission("eaglefactions.player.help").arguments(GenericArguments.optional((CommandElement)GenericArguments.integer((Text)Text.of((String)"page")))).executor((CommandExecutor)new HelpCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("c", "create"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_CREATE_DESC)).permission("eaglefactions.player.create").arguments(new CommandElement[]{GenericArguments.string((Text)Text.of((String)"tag")), GenericArguments.string((Text)Text.of((String)"name"))}).executor((CommandExecutor)new CreateCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("disband"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_DISBAND_DESC)).permission("eaglefactions.player.disband").arguments(GenericArguments.optional((CommandElement)new FactionArgument(this, (Text)Text.of((String)"faction")))).executor((CommandExecutor)new DisbandCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("list"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_LIST_DESC)).permission("eaglefactions.player.list").executor((CommandExecutor)new ListCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("invite"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_INVITE_DESC)).permission("eaglefactions.player.invite").arguments(GenericArguments.onlyOne((CommandElement)GenericArguments.player((Text)Text.of((String)"player")))).executor((CommandExecutor)new InviteCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("kick"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_KICK_DESC)).permission("eaglefactions.player.kick").arguments(GenericArguments.onlyOne((CommandElement)new FactionPlayerArgument(this, (Text)Text.of((String)"player")))).executor((CommandExecutor)new KickCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("j", "join"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_JOIN_DESC)).permission("eaglefactions.player.join").arguments((CommandElement)new FactionArgument(this, (Text)Text.of((String)"faction"))).executor((CommandExecutor)new JoinCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("leave"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_LEAVE_DESC)).permission("eaglefactions.player.leave").executor((CommandExecutor)new LeaveCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("v", "version"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_VERSION_DESC)).permission("eaglefactions.player.version").executor((CommandExecutor)new VersionCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("i", "info"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_INFO_DESC)).arguments(GenericArguments.optional((CommandElement)new FactionArgument(this, (Text)Text.of((String)"faction")))).executor((CommandExecutor)new InfoCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("p", "player"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_PLAYER_DESC)).permission("eaglefactions.player.player").arguments(GenericArguments.optional((CommandElement)new FactionPlayerArgument(this, (Text)Text.of((String)"player")))).executor((CommandExecutor)new PlayerCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("truce"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_TRUCE_DESC)).permission("eaglefactions.player.truce").arguments(GenericArguments.onlyOne((CommandElement)new FactionArgument(this, (Text)Text.of((String)"faction")))).executor((CommandExecutor)new TruceCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("ally"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_ALLY_DESC)).permission("eaglefactions.player.ally").arguments(GenericArguments.onlyOne((CommandElement)new FactionArgument(this, (Text)Text.of((String)"faction")))).executor((CommandExecutor)new AllyCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("enemy"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_ENEMY_DESC)).permission("eaglefactions.player.enemy").arguments(GenericArguments.onlyOne((CommandElement)new FactionArgument(this, (Text)Text.of((String)"faction")))).executor((CommandExecutor)new EnemyCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("promote"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_PROMOTE_DESC)).arguments(GenericArguments.onlyOne((CommandElement)new OwnFactionPlayerArgument(this, (Text)Text.of((String)"player")))).permission("eaglefactions.player.promote").executor((CommandExecutor)new PromoteCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("demote"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_DEMOTE_DESC)).arguments(GenericArguments.onlyOne((CommandElement)new OwnFactionPlayerArgument(this, (Text)Text.of((String)"player")))).permission("eaglefactions.player.demote").executor((CommandExecutor)new DemoteCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("claims", "listclaims"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_LIST_CLAIMS_DESC)).permission("eaglefactions.player.claims").arguments(GenericArguments.optional((CommandElement)new FactionArgument(this, (Text)Text.of((String)"faction")))).executor((CommandExecutor)new ClaimsListCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("claim"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_CLAIM_DESC)).permission("eaglefactions.player.claim").arguments(GenericArguments.optional((CommandElement)new FactionArgument(this, (Text)Text.of((String)"faction")))).executor((CommandExecutor)new ClaimCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("squareclaim"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_SQUARE_CLAIM_DESC)).permission("eaglefactions.player.radiusclaim").arguments(GenericArguments.onlyOne((CommandElement)GenericArguments.integer((Text)Text.of((String)"radius")))).executor((CommandExecutor)new SquareClaimCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("unclaim"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_UNCLAIM_DESC)).permission("eaglefactions.player.unclaim").executor((CommandExecutor)new UnclaimCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("unclaimall"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_UNCLAIM_ALL_DESC)).permission("eaglefactions.player.unclaimall").executor((CommandExecutor)new UnclaimAllCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("map"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_MAP_DESC)).permission("eaglefactions.player.map").executor((CommandExecutor)new MapCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("sethome"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_SET_HOME_DESC)).permission("eaglefactions.player.sethome").executor((CommandExecutor)new SetHomeCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("home"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_HOME_DESC)).permission("eaglefactions.player.home").arguments(GenericArguments.optional((CommandElement)new FactionArgument(this, (Text)Text.of((String)"faction")))).executor((CommandExecutor)new HomeCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("autoclaim"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_AUTO_CLAIM_DESC)).permission("eaglefactions.player.autoclaim").executor((CommandExecutor)new AutoClaimCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("automap"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_AUTO_MAP_DESC)).permission("eaglefactions.player.automap").executor((CommandExecutor)new AutoMapCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("coords"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_COORDS_DESC)).permission("eaglefactions.player.coords").arguments(GenericArguments.optional((CommandElement)new FactionArgument(this, (Text)Text.of((String)"faction")))).executor((CommandExecutor)new CoordsCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("setpower"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_SET_POWER_DESC)).permission("eaglefactions.admin.setpower").arguments(new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.player((Text)Text.of((String)"player"))), GenericArguments.onlyOne((CommandElement)GenericArguments.doubleNum((Text)Text.of((String)"power")))}).executor((CommandExecutor)new SetPowerCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("maxpower"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_SET_MAX_POWER_DESC)).permission("eaglefactions.admin.maxpower").arguments(new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.player((Text)Text.of((String)"player"))), GenericArguments.onlyOne((CommandElement)GenericArguments.doubleNum((Text)Text.of((String)"power")))}).executor((CommandExecutor)new MaxPowerCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("attack"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_ATTACK_DESC)).permission("eaglefactions.player.attack").executor((CommandExecutor)new AttackCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("reload"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_RELOAD_DESC)).permission("eaglefactions.admin.reload").executor((CommandExecutor)new ReloadCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("chat"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_CHAT_DESC)).permission("eaglefactions.player.chat").arguments(GenericArguments.optional((CommandElement)GenericArguments.enumValue((Text)Text.of((String)"chat"), ChatEnum.class))).executor((CommandExecutor)new ChatCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("top"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_TOP_DESC)).permission("eaglefactions.player.top").executor((CommandExecutor)new TopCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("setleader"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_SET_LEADER_DESC)).permission("eaglefactions.player.setleader").arguments(GenericArguments.onlyOne((CommandElement)new FactionPlayerArgument(this, (Text)Text.of((String)"player")))).executor((CommandExecutor)new SetLeaderCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("perms"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_PERMS_DESC)).permission("eaglefactions.player.perms").executor((CommandExecutor)new PermsCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("tagcolor"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_TAG_COLOR_DESC)).permission("eaglefactions.player.tagcolor").arguments(GenericArguments.catalogedElement((Text)Text.of((String)"color"), TextColor.class)).executor((CommandExecutor)new TagColorCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("rename"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_RENAME_DESC)).permission("eaglefactions.player.rename").arguments(GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)"name")))).executor((CommandExecutor)new RenameCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("tag"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_TAG_DESC)).permission("eaglefactions.player.tag").arguments(GenericArguments.string((Text)Text.of((String)"tag"))).executor((CommandExecutor)new TagCommand(this)).build());
        SUBCOMMANDS.put(Arrays.asList("desc", "description"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_DESC_DESC)).permission("eaglefactions.player.description").arguments(GenericArguments.remainingJoinedStrings((Text)Text.of((String)"description"))).executor((CommandExecutor)new DescriptionCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("motd"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_MOTD_DESC)).permission("eaglefactions.player.motd").arguments(GenericArguments.remainingJoinedStrings((Text)Text.of((String)"motd"))).executor((CommandExecutor)new MotdCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("feather"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_FEATHER_DESC)).permission("eaglefactions.admin.feather").executor((CommandExecutor)new EagleFeatherCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("chest"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_CHEST_DESC)).permission("eaglefactions.player.chest").arguments(GenericArguments.optional((CommandElement)new FactionArgument(this, (Text)Text.of((String)"faction")))).executor((CommandExecutor)new ChestCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("public"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_PUBLIC_DESC)).permission("eaglefactions.player.public").arguments(GenericArguments.optional((CommandElement)new FactionArgument(this, (Text)Text.of((String)"faction")))).executor((CommandExecutor)new PublicCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("debug"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_DEBUG_DESC)).permission("eaglefactions.admin.debug").executor((CommandExecutor)new DebugCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("createbackup"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_CREATE_BACKUP_DESC)).permission("eaglefactions.admin.backup.create").executor((CommandExecutor)new BackupCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("restorebackup"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_RESTORE_BACKUP_DESC)).permission("eaglefactions.admin.backup.restore").arguments(GenericArguments.onlyOne((CommandElement)new BackupNameArgument(this, (Text)Text.of((String)"filename")))).executor((CommandExecutor)new RestoreBackupCommand(this)).build());
        SUBCOMMANDS.put(Collections.singletonList("regen"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_REGEN_DESC)).permission("eaglefactions.admin.regen").arguments(GenericArguments.onlyOne((CommandElement)new FactionArgument(this, (Text)Text.of((String)"faction")))).executor((CommandExecutor)new RegenCommand(this)).build());
        CommandSpec accessPlayerCommand = CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_ACCESS_PLAYER_DESC)).permission("eaglefactions.player.access.player").arguments(GenericArguments.onlyOne((CommandElement)new OwnFactionPlayerArgument(this, (Text)Text.of((String)"player")))).executor((CommandExecutor)new AccessPlayerCommand(this)).build();
        CommandSpec accessFactionCommand = CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_ACCESS_FACTION_DESC)).permission("eaglefactions.player.access.faction").executor((CommandExecutor)new AccessFactionCommand(this)).build();
        CommandSpec accessOwnedByCommand = CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_ACCESS_OWNED_BY_DESC)).permission("eaglefactions.player.access.ownedby").arguments(GenericArguments.onlyOne((CommandElement)new OwnFactionPlayerArgument(this, (Text)Text.of((String)"player")))).executor((CommandExecutor)new OwnedByCommand(this)).build();
        CommandSpec accessibleByFactionCommand = CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_ACCESS_ACCESSIBLE_BY_FACTION_DESC)).permission("eaglefactions.player.access.notaccessiblebyfaction").executor((CommandExecutor)new NotAccessibleByFactionCommand(this)).build();
        SUBCOMMANDS.put(Collections.singletonList("access"), CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_ACCESS_DESC)).permission("eaglefactions.player.access").executor((CommandExecutor)new AccessCommand(this)).child((CommandCallable)accessPlayerCommand, new String[]{"player", "p"}).child((CommandCallable)accessFactionCommand, new String[]{"faction", "f"}).child((CommandCallable)accessOwnedByCommand, new String[]{"ownedBy"}).child((CommandCallable)accessibleByFactionCommand, new String[]{"notAccessibleByFaction"}).build());
        CommandSpec commandEagleFactions = CommandSpec.builder().description((Text)Text.of((String)Messages.COMMAND_HELP_DESC)).executor((CommandExecutor)new HelpCommand(this)).children(SUBCOMMANDS).build();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)commandEagleFactions, new String[]{"factions", "faction", "f"});
    }

    private void registerListeners() {
        Sponge.getEventManager().registerListeners((Object)this, (Object)new EntityDamageListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new PlayerJoinListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new PlayerDeathListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new BlockPlaceListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new BlockBreakListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new PlayerInteractListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new PlayerMoveListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new ChatMessageListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new EntitySpawnListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new PlayerDisconnectListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new SendCommandListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new ExplosionListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new ModifyBlockListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new NotifyNeighborBlockListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new FactionKickListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new FactionLeaveListener(this));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new FactionJoinListener(this));
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public PVPLogger getPVPLogger() {
        return this.pvpLogger;
    }

    @Override
    public PermsManager getPermsManager() {
        return this.permsManager;
    }

    @Override
    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    @Override
    public PowerManager getPowerManager() {
        return this.powerManager;
    }

    @Override
    public ProtectionManager getProtectionManager() {
        return this.protectionManager;
    }

    @Override
    public AttackLogic getAttackLogic() {
        return this.attackLogic;
    }

    @Override
    public FactionLogic getFactionLogic() {
        return this.factionLogic;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public Faction.Builder getBuilderForFaction(String name, Text tag, UUID leader) {
        return new FactionImpl.BuilderImpl(name, tag, leader);
    }

    @Override
    public FactionPlayer createNewFactionPlayer(String playerName, UUID uniqueId, String factionName, float power, float maxpower, FactionMemberType factionRole, boolean diedInWarZone) {
        return new FactionPlayerImpl(playerName, uniqueId, factionName, power, maxpower, factionRole, diedInWarZone);
    }

    public InputStream getResourceAsStream(String fileName) {
        return this.getClass().getClassLoader().getResourceAsStream(fileName);
    }

    @Override
    public URL getResource(String fileName) {
        return this.getClass().getResource(fileName);
    }

    @Override
    public void printInfo(String message) {
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.YELLOW, message}));
    }

    private void setupConfigs() {
        this.configuration = new ConfigurationImpl(this.configDir, this.configAsset);
        MessageLoader messageLoader = MessageLoader.getInstance(this);
        this.pvpLogger = PVPLoggerImpl.getInstance(this);
    }

    private void setupManagers() {
        this.storageManager = new StorageManagerImpl(this, this.configuration.getStorageConfig(), this.configDir);
        this.playerManager = new PlayerManagerImpl(this.storageManager, this.factionLogic, this.getConfiguration().getFactionsConfig(), this.configuration.getPowerConfig());
        this.powerManager = new PowerManagerImpl(this.playerManager, this.configuration.getPowerConfig());
        this.permsManager = new PermsManagerImpl();
        this.factionLogic = new FactionLogicImpl(this.playerManager, this.storageManager, this.getConfiguration().getFactionsConfig());
        this.attackLogic = new AttackLogicImpl(this.factionLogic, this.getConfiguration().getFactionsConfig());
        this.protectionManager = new ProtectionManagerImpl(this.factionLogic, this.permsManager, this.playerManager, this.configuration.getProtectionConfig(), this.configuration.getChatConfig(), this.configuration.getFactionsConfig());
    }

    private void startFactionsRemover() {
        if (this.getConfiguration().getFactionsConfig().getMaxInactiveTime() == 0L) {
            return;
        }
        EagleFactionsScheduler.getInstance().scheduleWithDelayedIntervalAsync(new FactionRemoverTask(eagleFactions), 0L, TimeUnit.SECONDS, 1L, TimeUnit.HOURS);
    }

    public EFPlaceholderService getEfPlaceholderService() {
        return this.efPlaceholderService;
    }

    public DynmapService getDynmapService() {
        return this.dynmapService;
    }
}

