/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.args;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;

public class OwnFactionPlayerArgument
extends CommandElement {
    private final EagleFactions plugin;

    public OwnFactionPlayerArgument(EagleFactions plugin, @Nullable Text key) {
        super(key);
        this.plugin = plugin;
    }

    @Nullable
    protected FactionPlayer parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        if (!(source instanceof Player)) {
            throw args.createError((Text)Text.of((String)Messages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND));
        }
        UUID playerUUID = ((Player)source).getUniqueId();
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(playerUUID);
        if (!optionalFaction.isPresent()) {
            throw args.createError((Text)Text.of((String)Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND));
        }
        Faction faction = optionalFaction.get();
        LinkedList<FactionPlayer> factionPlayers = new LinkedList<FactionPlayer>();
        for (UUID uuid : faction.getPlayers()) {
            Optional<FactionPlayer> factionPlayer = this.plugin.getPlayerManager().getFactionPlayer(uuid);
            factionPlayers.add(factionPlayer.get());
        }
        if (args.hasNext()) {
            String argument = args.next();
            for (FactionPlayer player : factionPlayers) {
                if (!player.getName().equals(argument)) continue;
                return player;
            }
            throw args.createError((Text)Text.of((String)"Argument is not a valid player!"));
        }
        throw args.createError((Text)Text.of((String)"Argument is not a valid player!"));
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        if (!(src instanceof Player)) {
            return Collections.EMPTY_LIST;
        }
        UUID playerUUID = ((Player)src).getUniqueId();
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(playerUUID);
        if (!optionalFaction.isPresent()) {
            return Collections.EMPTY_LIST;
        }
        Faction faction = optionalFaction.get();
        LinkedList<FactionPlayer> factionPlayers = new LinkedList<FactionPlayer>();
        for (UUID uuid : faction.getPlayers()) {
            Optional<FactionPlayer> factionPlayer = this.plugin.getPlayerManager().getFactionPlayer(uuid);
            factionPlayers.add(factionPlayer.get());
        }
        if (args.hasNext()) {
            String charSequence = (String)args.nextIfPresent().get();
            ArrayList<String> resultList = new ArrayList<String>();
            for (int i = 0; i < factionPlayers.size(); ++i) {
                FactionPlayer factionPlayer = (FactionPlayer)factionPlayers.get(i);
                String factionPlayerName = factionPlayer.getName();
                if (!factionPlayerName.toLowerCase().startsWith(charSequence.toLowerCase())) continue;
                resultList.add(factionPlayerName);
            }
            return resultList;
        }
        return factionPlayers.stream().map(FactionPlayer::getName).collect(Collectors.toList());
    }
}

