/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.scheduling;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsConsumerTask;
import java.util.Optional;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.format.TextColors;

public class ClaimDelayTask
implements EagleFactionsConsumerTask<Task> {
    private final FactionsConfig factionsConfig;
    private final FactionLogic factionLogic = EagleFactionsPlugin.getPlugin().getFactionLogic();
    private final Player player;
    private final Vector3i chunkPosition;
    private final int claimDelay;
    private final boolean shouldClaimByItems;
    private int currentWaitSeconds = 0;

    public ClaimDelayTask(Player player, Vector3i chunkPosition) {
        this.player = player;
        this.chunkPosition = chunkPosition;
        this.factionsConfig = EagleFactionsPlugin.getPlugin().getConfiguration().getFactionsConfig();
        this.claimDelay = this.factionsConfig.getClaimDelay();
        this.shouldClaimByItems = this.factionsConfig.shouldClaimByItems();
    }

    @Override
    public void accept(Task task) {
        if (!this.chunkPosition.equals((Object)this.player.getLocation().getChunkPosition())) {
            this.player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MOVED_FROM_THE_CHUNK}));
            task.cancel();
        }
        if (this.currentWaitSeconds >= this.claimDelay) {
            Optional<Faction> optionalFaction = this.factionLogic.getFactionByPlayerUUID(this.player.getUniqueId());
            if (!optionalFaction.isPresent()) {
                this.player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
                task.cancel();
            }
            if (this.shouldClaimByItems) {
                boolean didSucceed = this.factionLogic.addClaimByItems(this.player, optionalFaction.get(), this.player.getWorld().getUniqueId(), this.chunkPosition);
                if (didSucceed) {
                    this.player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, Messages.LAND + " ", TextColors.GOLD, this.chunkPosition.toString(), TextColors.WHITE, " " + Messages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, Messages.CLAIMED, TextColors.WHITE, "!"}));
                } else {
                    this.player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_DONT_HAVE_ENOUGH_RESOURCES_TO_CLAIM_A_TERRITORY}));
                }
            } else {
                this.factionLogic.addClaim(optionalFaction.get(), new Claim(this.player.getWorld().getUniqueId(), this.chunkPosition));
                this.player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, Messages.LAND + " ", TextColors.GOLD, this.chunkPosition.toString(), TextColors.WHITE, " " + Messages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, Messages.CLAIMED, TextColors.WHITE, "!"}));
                EventRunner.runFactionClaimEventPost(this.player, optionalFaction.get(), this.player.getWorld(), this.chunkPosition);
            }
            task.cancel();
        } else {
            this.player.sendMessage(ChatTypes.ACTION_BAR, Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RESET, this.currentWaitSeconds}));
            ++this.currentWaitSeconds;
        }
    }
}

