/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.api.core;

public final class NucleusAPIMetaService {
    private final String version;
    private final String semver;
    private final int majorVersion;
    private final int minorVersion;
    private final int patchVersion;
    private final boolean release;

    public NucleusAPIMetaService(String version) {
        this.version = version;
        String[] sp = version.split("\\.", 3);
        String[] patch = sp[2].split("-", 2);
        this.majorVersion = this.parse(sp[0]);
        this.minorVersion = this.parse(sp[1]);
        this.patchVersion = this.parse(patch[0]);
        this.semver = String.format("%d.%d.%d", this.majorVersion, this.minorVersion, this.patchVersion);
        this.release = patch.length == 2 && !patch[1].isEmpty();
    }

    public String version() {
        return this.version;
    }

    public String semanticVersion() {
        return this.semver;
    }

    public int major() {
        return this.majorVersion;
    }

    public int minor() {
        return this.minorVersion;
    }

    public int patch() {
        return this.patchVersion;
    }

    public boolean isRelease() {
        return this.release;
    }

    private int parse(String string) {
        try {
            return Integer.parseUnsignedInt(string);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

