/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.configurate.datatypes;

import io.github.nucleuspowered.nucleus.modules.core.CoreKeys;
import io.github.nucleuspowered.nucleus.modules.jail.JailKeys;
import io.github.nucleuspowered.nucleus.modules.jail.data.JailData;
import io.github.nucleuspowered.nucleus.modules.mute.MuteKeys;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import java.util.Optional;
import javax.annotation.Nullable;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;

@ConfigSerializable
public class UserCacheDataNode {
    @Setting
    @Nullable
    private String ipAddress;
    @Setting
    @Nullable
    private String jail = null;
    @Setting
    private boolean isMuted = false;

    public UserCacheDataNode() {
    }

    public UserCacheDataNode(IUserDataObject x) {
        this.set(x);
    }

    public void set(IUserDataObject x) {
        this.ipAddress = x.get(CoreKeys.IP_ADDRESS).map(y -> y.replace("/", "")).orElse(null);
        this.jail = x.get(JailKeys.JAIL_DATA).map(JailData::getJailName).orElse(null);
        this.isMuted = x.get(MuteKeys.MUTE_DATA).isPresent();
    }

    public Optional<String> getIpAddress() {
        return Optional.ofNullable(this.ipAddress);
    }

    public boolean isJailed() {
        return this.getJailName().isPresent();
    }

    public Optional<String> getJailName() {
        return Optional.ofNullable(this.jail);
    }

    public boolean isMuted() {
        return this.isMuted;
    }
}

