/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.admin.commands;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.util.TypeTokens;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.monster.Monster;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@Command(aliases={"killentity"}, basePermission={"nucleus.killentity.base"}, commandDescriptionKey="killentity", modifiers={@CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.killentity.exempt.warmup"), @CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.killentity.exempt.cooldown"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.killentity.exempt.cost")})
@NonnullByDefault
public class KillEntityCommand
implements ICommandExecutor<CommandSource> {
    private static final String radius = "radius";
    private static final String world = "world";
    private static final String type = "type";
    private static final Predicate<Entity> armourStand = e -> e.getType().equals(EntityTypes.ARMOR_STAND);
    private static final Predicate<Entity> hostile = e -> e instanceof Monster;
    private static final Predicate<Entity> passive = e -> e instanceof Living && !(e instanceof Player) && !(e instanceof Monster);
    private final Map<String, ?> map = new HashMap<String, Predicate<Entity>>(){
        {
            this.put("armorstand", armourStand);
            this.put("armourstand", armourStand);
            this.put("monsters", hostile);
            this.put("hostile", hostile);
            this.put("passive", passive);
            this.put("animal", passive);
            this.put("item", e -> e instanceof Item);
            this.put("player", e -> e instanceof Player);
        }
    };

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().setAnchorFlags(true).valueFlag(GenericArguments.integer((Text)Text.of((String)radius)), new String[]{"r"}).valueFlag(NucleusParameters.WORLD_PROPERTIES_LOADED_ONLY.get(serviceCollection), new String[]{"w"}).buildWith(GenericArguments.allOf((CommandElement)GenericArguments.choices((Text)Text.of((String)type), this.map)))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        HashSet currentEntities;
        CommandSource src = context.getCommandSource();
        if (!(src instanceof Locatable) && context.hasAny(radius)) {
            return context.errorResult("command.killentity.commandsourceradius", new Object[0]);
        }
        if (context.hasAny(radius) && context.hasAny(world)) {
            return context.errorResult("command.killentity.radiusworld", new Object[0]);
        }
        if (context.hasAny(radius)) {
            Locatable l = (Locatable)src;
            Vector3d locationTest = l.getLocation().getPosition();
            int r = context.requireOne(radius, Integer.TYPE);
            currentEntities = Sets.newHashSet((Iterable)l.getWorld().getEntities(entity -> entity.getTransform().getPosition().distance(locationTest) <= (double)r));
        } else {
            WorldProperties worldProperties = context.hasAny(world) ? context.requireOne(world, WorldProperties.class) : (src instanceof Locatable ? ((Locatable)src).getWorld().getProperties() : (WorldProperties)Sponge.getServer().getDefaultWorld().get());
            currentEntities = Sets.newHashSet((Iterable)((World)Sponge.getServer().getWorld(worldProperties.getUniqueId()).get()).getEntities());
        }
        Predicate<Entity> entityPredicate = context.getAll(type, TypeTokens.PREDICATE_ENTITY).stream().reduce(Predicate::or).orElseThrow(() -> context.createException("command.killentity.noselection", new Object[0]));
        Set<Entity> toKill = currentEntities.stream().filter(entityPredicate).collect(Collectors.toSet());
        if (toKill.isEmpty()) {
            return context.errorResult("command.killentity.nothing", new Object[0]);
        }
        int killCount = toKill.size();
        toKill.forEach(x -> {
            x.offer(Keys.HEALTH, (Object)0.0);
            x.remove();
        });
        context.sendMessage("command.killentity.success", String.valueOf(killCount));
        return context.successResult();
    }
}

