/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.admin.commands;

import io.github.nucleuspowered.nucleus.configurate.config.CommonPermissionLevelConfig;
import io.github.nucleuspowered.nucleus.modules.admin.config.AdminConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"sudo"}, basePermission={"nucleus.sudo.base"}, commandDescriptionKey="sudo", associatedPermissionLevelKeys={"nucleus.sudo.level"})
@EssentialsEquivalent(value={"sudo"})
@NonnullByDefault
public class SudoCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private CommonPermissionLevelConfig levelConfig = new CommonPermissionLevelConfig();

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.ONE_PLAYER.get(serviceCollection), NucleusParameters.COMMAND};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player pl = context.requireOne("player", Player.class);
        String cmd = context.requireOne("command", String.class);
        if (context.is(pl) || !context.isConsoleAndBypass() && context.testPermissionFor((Subject)pl, "nucleus.sudo.exempt.target")) {
            return context.errorResult("command.sudo.noperms", new Object[0]);
        }
        if (this.levelConfig.isUseLevels() && !context.isPermissionLevelOkay((Subject)pl, "nucleus.sudo.level", "nucleus.sudo.base", this.levelConfig.isCanAffectSameLevel())) {
            return context.errorResult("command.modifiers.level.insufficient", pl.getName());
        }
        if (cmd.startsWith("c:")) {
            if (cmd.equals("c:")) {
                return context.errorResult("command.sudo.chatfail", new Object[0]);
            }
            LiteralText rawMessage = Text.of((String)cmd.split(":", 2)[1]);
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause((Object)context.getCommandSource());
                frame.pushCause((Object)pl);
                frame.addContext(EventContextKeys.PLAYER_SIMULATED, (Object)pl.getProfile());
                if (pl.simulateChat((Text)rawMessage, frame.getCurrentCause()).isCancelled()) {
                    ICommandResult iCommandResult = context.errorResult("command.sudo.chatcancelled", new Object[0]);
                    return iCommandResult;
                }
            }
            return context.successResult();
        }
        context.sendMessage("command.sudo.force", pl.getName(), cmd);
        Sponge.getCommandManager().process((CommandSource)pl, cmd);
        return context.successResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.levelConfig = serviceCollection.moduleDataProvider().getModuleConfig(AdminConfig.class).getLevelConfig();
    }
}

