/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.back.commands;

import io.github.nucleuspowered.nucleus.modules.back.services.BackHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;

@Command(aliases={"clearback"}, basePermission={"nucleus.clearback.base"}, commandDescriptionKey="clearback")
public class ClearBackCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)NucleusParameters.ONE_USER.get(serviceCollection))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        User target = context.getUserFromArgs();
        boolean isSelf = context.is(target);
        if (!isSelf && !context.testPermission("nucleus.clearback.others")) {
            return context.errorResult("command.clearback.other.noperm", new Object[0]);
        }
        context.getServiceCollection().getServiceUnchecked(BackHandler.class).removeLastLocation(target);
        context.sendMessage("command.clearback.success", target.getName());
        return context.successResult();
    }
}

